/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.install;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.ui.UI;
import java.util.Locale;
import org.openthinclient.api.context.InstallContext;
import org.openthinclient.wizard.install.InstallState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstallStep {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile InstallState installState = InstallState.PENDING;
    protected final IMessageConveyor mc;

    public AbstractInstallStep() {
        Locale locale = UI.getCurrent() != null ? UI.getCurrent().getLocale() : Locale.getDefault();
        this.mc = new MessageConveyor(locale);
    }

    public InstallState getState() {
        return this.installState;
    }

    public final void execute(InstallContext installContext) {
        this.log.info("Starting install task");
        this.installState = InstallState.RUNNING;
        try {
            this.doExecute(installContext);
            this.log.info("Install task completed.");
            this.installState = InstallState.FINISHED;
            return;
        }
        catch (Exception e) {
            this.log.error("Install task failed.", (Throwable)e);
            this.installState = InstallState.FAILED;
            throw new RuntimeException(e);
        }
    }

    protected abstract void doExecute(InstallContext var1) throws Exception;

    public abstract String getName();

    public abstract double getProgress();
}

