/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.install;

import org.openthinclient.api.context.InstallContext;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.service.common.ServerIDFactory;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.home.ManagerHomeMetadata;
import org.openthinclient.service.common.home.impl.ManagerHomeFactory;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.install.AbstractInstallStep;
import org.openthinclient.wizard.model.NetworkConfigurationModel;

public class PrepareManagerHomeInstallStep
extends AbstractInstallStep {
    private final ManagerHomeFactory managerHomeFactory;
    private final NetworkConfigurationModel networkConfigurationModel;

    public PrepareManagerHomeInstallStep(ManagerHomeFactory managerHomeFactory, NetworkConfigurationModel networkConfigurationModel) {
        this.managerHomeFactory = managerHomeFactory;
        this.networkConfigurationModel = networkConfigurationModel;
    }

    @Override
    public String getName() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_PREPAREMANAGERHOMEINSTALLSTEP_LABEL, new Object[0]);
    }

    @Override
    protected void doExecute(InstallContext installContext) throws Exception {
        this.log.info("Preparing the manager home directory: " + this.managerHomeFactory.getManagerHomeDirectory().getAbsolutePath());
        this.managerHomeFactory.getManagerHomeDirectory().mkdirs();
        ManagerHome managerHome = this.managerHomeFactory.create();
        ManagerHomeMetadata metadata = managerHome.getMetadata();
        metadata.setServerID(ServerIDFactory.create());
        metadata.save();
        this.log.info("\n#########################################################\n# Server ID: " + metadata.getServerID() + "\n#########################################################");
        this.log.info("Performing the minimum system configuration.");
        PackageManagerConfiguration packageManagerConfiguration = (PackageManagerConfiguration)managerHome.getConfiguration(PackageManagerConfiguration.class);
        if (this.networkConfigurationModel.getProxyConnectionProperty().booleanValue()) {
            this.log.info("Setting up the proxy configuration");
            packageManagerConfiguration.setProxyConfiguration(this.networkConfigurationModel.getProxyConfiguration());
            packageManagerConfiguration.getProxyConfiguration().setEnabled(true);
        }
        managerHome.saveAll();
        installContext.setManagerHome(managerHome);
    }

    @Override
    public double getProgress() {
        return 1.0;
    }
}

