/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.openthinclient.api.distributions.InstallableDistribution;
import org.openthinclient.api.distributions.InstallableDistributions;
import org.openthinclient.service.common.home.impl.ManagerHomeFactory;
import org.openthinclient.wizard.install.InstallSystemTask;
import org.openthinclient.wizard.model.DatabaseModel;
import org.openthinclient.wizard.model.DirectoryModel;
import org.openthinclient.wizard.model.NetworkConfigurationModel;
import org.springframework.core.task.AsyncListenableTaskExecutor;

public class InstallModel {
    public static final InstallableDistribution DEFAULT_DISTRIBUTION = InstallableDistributions.getPreferredDistribution();
    private final List<InstallableDistribution> installableDistributions;
    private final AsyncListenableTaskExecutor taskExecutor;
    private final DirectoryModel directoryModel;
    private final NetworkConfigurationModel networkConfigurationModel;
    private final DatabaseModel databaseModel;
    private volatile InstallSystemTask installSystemTask;

    public InstallModel(AsyncListenableTaskExecutor taskExecutor, DirectoryModel directoryModel, NetworkConfigurationModel networkConfigurationModel, DatabaseModel databaseModel) {
        this.taskExecutor = taskExecutor;
        this.directoryModel = directoryModel;
        this.networkConfigurationModel = networkConfigurationModel;
        this.databaseModel = databaseModel;
        this.installableDistributions = new ArrayList<InstallableDistribution>();
        this.installableDistributions.add(DEFAULT_DISTRIBUTION);
    }

    public List<InstallableDistribution> getInstallableDistributions() {
        return this.installableDistributions;
    }

    public boolean isInstallInProgress() {
        return this.installSystemTask != null;
    }

    public InstallSystemTask installSystem(ManagerHomeFactory factory, InstallableDistribution installableDistribution, boolean applicationIsPreview) {
        this.installSystemTask = new InstallSystemTask(factory, installableDistribution, this.directoryModel, this.networkConfigurationModel, this.databaseModel, applicationIsPreview);
        this.taskExecutor.submitListenable((Callable)this.installSystemTask);
        return this.installSystemTask;
    }

    public InstallSystemTask getInstallSystemTask() {
        return this.installSystemTask;
    }
}

