/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.event.UIEvents;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openthinclient.manager.runtime.util.RestartApplicationEvent;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.install.AbstractInstallStep;
import org.openthinclient.wizard.install.InstallState;
import org.openthinclient.wizard.model.InstallModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class SystemInstallProgressPresenter {
    private static final Logger LOG = LoggerFactory.getLogger(SystemInstallProgressPresenter.class);
    private final InstallModel installModel;
    private final List<StepAndView> stepAndViews;
    private final ApplicationEventPublisher publisher;
    protected IMessageConveyor mc;

    public SystemInstallProgressPresenter(ApplicationEventPublisher publisher, InstallModel installModel) {
        this.publisher = publisher;
        this.installModel = installModel;
        this.stepAndViews = new ArrayList<StepAndView>();
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
    }

    public void present(UI ui, View view) {
        ui.setPollInterval(500);
        ui.addPollListener((UIEvents.PollListener & Serializable)event -> this.update(view));
        view.setTitle(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_SYSTEMINSTALLPROGRESSPRESENTER_TITLE, new Object[0]));
        view.setDescription(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_SYSTEMINSTALLPROGRESSPRESENTER_DESCRIPTION, new Object[0]));
        this.installModel.getInstallSystemTask().getSteps().forEach(step -> {
            InstallItemView itemView = view.addItemView();
            itemView.setTitle(step.getName());
            this.stepAndViews.add(new StepAndView((AbstractInstallStep)step, itemView));
        });
        this.update(view);
    }

    private void update(View view) {
        this.stepAndViews.forEach(stepAndView -> {
            switch (stepAndView.getStep().getState()) {
                case PENDING: {
                    stepAndView.getView().setPending();
                    break;
                }
                case RUNNING: {
                    stepAndView.getView().setProgress(stepAndView.getStep().getProgress());
                    break;
                }
                case FINISHED: {
                    stepAndView.getView().setFinished();
                    break;
                }
                case FAILED: {
                    stepAndView.getView().setFailed();
                }
            }
        });
        if (this.installModel.getInstallSystemTask().getInstallState() == InstallState.FINISHED) {
            view.setDescription(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_SYSTEMINSTALLPROGRESSPRESENTER_FINISHED_MESSAGE, new Object[0]));
            LOG.info("\n\n==============================================\n Starting\n==============================================\n\n");
            this.publisher.publishEvent((ApplicationEvent)new RestartApplicationEvent((Object)this));
            UI.getCurrent().getPage().setLocation("/restart/server-restart.html");
        }
    }

    protected static final class StepAndView {
        private final AbstractInstallStep step;
        private final InstallItemView view;

        public StepAndView(AbstractInstallStep step, InstallItemView view) {
            this.step = step;
            this.view = view;
        }

        public AbstractInstallStep getStep() {
            return this.step;
        }

        public InstallItemView getView() {
            return this.view;
        }
    }

    public static interface InstallItemView {
        public void setTitle(String var1);

        public void setPending();

        public void setRunning();

        public void setFailed();

        public void setFinished();

        public void remove();

        public void setProgress(double var1);
    }

    public static interface View {
        public void setTitle(String var1);

        public void setDescription(String var1);

        public InstallItemView addItemView();
    }
}

