/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.ui.SystemInstallProgressPresenter;

public class SystemInstallProgressView
extends VerticalLayout
implements SystemInstallProgressPresenter.View {
    private final List<InstallItemViewImpl> statusLabels;
    private final Label titleLabel;
    private final Label descriptionLabel;
    protected IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());

    public SystemInstallProgressView() {
        this.setSpacing(true);
        this.titleLabel = this.createH1Label("");
        this.addComponent((Component)this.titleLabel);
        this.descriptionLabel = this.createLargeLabel("");
        this.addComponent((Component)this.descriptionLabel);
        this.statusLabels = new ArrayList<InstallItemViewImpl>();
    }

    private Label createH1Label(String label) {
        Label l = new Label(label);
        l.setStyleName("h1");
        return l;
    }

    private Label createLargeLabel(String label) {
        Label l = new Label(label);
        l.setStyleName("large");
        return l;
    }

    @Override
    public void setDescription(String description) {
        this.descriptionLabel.setValue(description);
    }

    @Override
    public void setTitle(String title) {
        this.titleLabel.setValue(title);
    }

    @Override
    public SystemInstallProgressPresenter.InstallItemView addItemView() {
        InstallItemViewImpl itemView = new InstallItemViewImpl();
        this.addComponent((Component)itemView);
        this.statusLabels.add(itemView);
        return itemView;
    }

    protected final class InstallItemViewImpl
    extends Panel
    implements SystemInstallProgressPresenter.InstallItemView {
        private final VerticalLayout content = new VerticalLayout();
        private NumberFormat defaultFormat;

        public InstallItemViewImpl() {
            this.content.setMargin(true);
            this.content.setSpacing(true);
            this.setContent((Component)this.content);
            this.defaultFormat = NumberFormat.getPercentInstance();
            this.defaultFormat.setMinimumFractionDigits(1);
        }

        @Override
        public void setTitle(String title) {
            this.setCaption(title);
        }

        @Override
        public void setPending() {
            this.content.removeAllComponents();
            this.content.addComponent((Component)new Label(SystemInstallProgressView.this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_STATE_PENDING, new Object[0])));
            this.setIcon((Resource)FontAwesome.PAUSE);
        }

        @Override
        public void setRunning() {
            this.content.removeAllComponents();
            HorizontalLayout hl = new HorizontalLayout();
            hl.setSpacing(true);
            ProgressBar progressBar = new ProgressBar();
            progressBar.setIndeterminate(true);
            hl.addComponent((Component)progressBar);
            hl.addComponent((Component)new Label(SystemInstallProgressView.this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_STATE_EXECUTING, new Object[0])));
            this.content.addComponent((Component)hl);
        }

        @Override
        public void setFailed() {
            this.content.removeAllComponents();
            this.setIcon((Resource)FontAwesome.TIMES);
            Label caption = new Label(SystemInstallProgressView.this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_STATE_FAILED, new Object[0]));
            caption.setStyleName("failure");
            Label message = new Label(SystemInstallProgressView.this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_STATE_FAILED_DESCRIPTION, new Object[0]));
            this.content.addComponents(new Component[]{caption, message});
        }

        @Override
        public void setFinished() {
            this.content.removeAllComponents();
            Label caption = new Label(SystemInstallProgressView.this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_STATE_SUCCEED, new Object[0]));
            caption.setStyleName("success");
            this.content.addComponent((Component)caption);
            this.setIcon((Resource)FontAwesome.CHECK);
        }

        @Override
        public void remove() {
            SystemInstallProgressView.this.statusLabels.remove(this);
            SystemInstallProgressView.this.removeComponent((Component)this);
        }

        @Override
        public void setProgress(double progress) {
            this.content.removeAllComponents();
            HorizontalLayout hl = new HorizontalLayout();
            hl.setSpacing(true);
            hl.addComponent((Component)new Label(SystemInstallProgressView.this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_STATE_EXECUTING, new Object[0]) + ": " + this.defaultFormat.format(progress)));
            this.content.addComponent((Component)hl);
        }
    }
}

