/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui.steps;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationException;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.OrganizationalUnit;
import org.openthinclient.common.model.User;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.model.SystemSetupModel;
import org.openthinclient.wizard.ui.steps.AbstractStep;
import org.openthinclient.wizard.ui.steps.PasswordIdenticalValidator;
import org.vaadin.teemu.wizards.Wizard;

public class ConfigureDirectoryStep
extends AbstractStep {
    private final SystemSetupModel systemSetupModel;
    private final Binder<OrganizationalUnit> primaryOUBinder;
    private final Binder<User> userBinder;

    public ConfigureDirectoryStep(Wizard wizard, SystemSetupModel systemSetupModel) {
        this.systemSetupModel = systemSetupModel;
        this.primaryOUBinder = new Binder();
        this.primaryOUBinder.setBean((Object)systemSetupModel.getDirectoryModel().getPrimaryOU());
        this.userBinder = new Binder();
        this.userBinder.setBean((Object)systemSetupModel.getDirectoryModel().getAdministratorUser());
        VerticalLayout contents = new VerticalLayout();
        contents.setSpacing(true);
        contents.setMargin(true);
        contents.addComponent((Component)this.createLabelH1(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_HEADLINE, new Object[0])));
        Label descriptionLabel = this.createLabelLarge(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_DESCRIPTION, new Object[0]), ContentMode.HTML);
        descriptionLabel.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        contents.addComponent((Component)descriptionLabel);
        contents.addComponent(this.createPrimaryOUPanel());
        contents.addComponent(this.createAdministratorUserPanel());
        this.setContent((Component)contents);
    }

    private Component createAdministratorUserPanel() {
        TextField username = new TextField(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_LABEL_DIR_USERNAME, new Object[0]));
        this.userBinder.forField((HasValue)username).asRequired(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_REQUIRED, new Object[0])).withValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_REQUIRED, new Object[0]), Integer.valueOf(1), null)).withValidator((Validator)new RegexpValidator(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_ONLYDIGITS, new Object[0]), "[a-zA-Z0-9]+")).bind(DirectoryObject::getName, DirectoryObject::setName);
        username.setRequiredIndicatorVisible(false);
        TextField givenName = new TextField(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_LABEL_DIR_FIRSTNAME, new Object[0]));
        this.userBinder.forField((HasValue)givenName).bind(User::getGivenName, User::setGivenName);
        TextField sn = new TextField(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_LABEL_DIR_LASTNAME, new Object[0]));
        this.userBinder.forField((HasValue)sn).asRequired(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_REQUIRED, new Object[0])).withValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_REQUIRED, new Object[0]), Integer.valueOf(1), null)).bind(User::getSn, User::setSn);
        sn.setRequiredIndicatorVisible(false);
        TextArea description = new TextArea(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_LABEL_DIR_DESCRIPTION, new Object[0]));
        description.setRows(2);
        this.userBinder.forField((HasValue)description).bind(DirectoryObject::getDescription, DirectoryObject::setDescription);
        description.setRequiredIndicatorVisible(false);
        PasswordField password = new PasswordField(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_LABEL_DIR_PASSWD, new Object[0]));
        this.userBinder.forField((HasValue)password).asRequired(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_REQUIRED, new Object[0])).withValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_REQUIRED, new Object[0]), Integer.valueOf(1), null)).withConverter(String::getBytes, String::new).withNullRepresentation((Object)new byte[0]).bind(User::getUserPassword, User::setUserPassword);
        PasswordField passwordVerify = new PasswordField(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_LABEL_DIR_PASSWD_REPEAT, new Object[0]));
        this.userBinder.forField((HasValue)passwordVerify).asRequired(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_REQUIRED, new Object[0])).withNullRepresentation((Object)"").withValidator((Validator)new PasswordIdenticalValidator(password)).withValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_REQUIRED, new Object[0]), Integer.valueOf(1), null)).bind(User::getVerifyPassword, User::setVerifyPassword);
        FormLayout formLayout = new FormLayout();
        Label section = new Label(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_LABEL_DIR_ADMINISTRATOR, new Object[0]));
        section.addStyleName("h3");
        section.addStyleName("colored");
        formLayout.addComponent((Component)section);
        formLayout.setStyleName("light");
        formLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        formLayout.setMargin(true);
        formLayout.addComponent((Component)username);
        formLayout.addComponent((Component)password);
        formLayout.addComponent((Component)passwordVerify);
        formLayout.addComponent((Component)givenName);
        formLayout.addComponent((Component)sn);
        formLayout.addComponent((Component)description);
        return formLayout;
    }

    private Component createPrimaryOUPanel() {
        FormLayout formLayout = new FormLayout();
        formLayout.setStyleName("primaryoupanel");
        Label section = new Label(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_LABEL_DIR_SYSTEM, new Object[0]));
        section.addStyleName("h3");
        section.addStyleName("colored");
        formLayout.addComponent((Component)section);
        formLayout.addStyleName("light");
        formLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        formLayout.setMargin(true);
        TextField systemName = new TextField(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_LABEL_DIR_SYSTEMNAME, new Object[0]), "name");
        this.primaryOUBinder.forField((HasValue)systemName).asRequired(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_REQUIRED, new Object[0])).withValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_REQUIRED, new Object[0]), Integer.valueOf(1), null)).withValidator((Validator)new RegexpValidator(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_VALIDATOR_FIELD_ONLYDIGITS, new Object[0]), "[a-zA-Z0-9]+")).bind(DirectoryObject::getName, DirectoryObject::setName);
        systemName.setRequiredIndicatorVisible(false);
        formLayout.addComponent((Component)systemName);
        TextArea description = new TextArea(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_LABEL_DIR_SYSTEMDESCRIPTION, new Object[0]), "description");
        description.setRows(1);
        this.primaryOUBinder.bind((HasValue)description, DirectoryObject::getDescription, DirectoryObject::setDescription);
        formLayout.addComponent((Component)description);
        return formLayout;
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREDIRECTORYSTEP_TITLE, new Object[0]);
    }

    public boolean onAdvance() {
        try {
            this.primaryOUBinder.writeBean((Object)this.systemSetupModel.getDirectoryModel().getPrimaryOU());
        }
        catch (ValidationException e) {
            this.notifyUser(e);
            return false;
        }
        try {
            this.userBinder.writeBean((Object)this.systemSetupModel.getDirectoryModel().getAdministratorUser());
        }
        catch (ValidationException e) {
            this.notifyUser(e);
            return false;
        }
        String password = new String(this.systemSetupModel.getDirectoryModel().getAdministratorUser().getUserPassword());
        this.systemSetupModel.getDirectoryModel().getAdministratorUser().setNewPassword(password);
        return true;
    }

    private void notifyUser(ValidationException e) {
        e.getFieldValidationErrors().stream().filter(s -> s.getField() instanceof Component).findFirst().ifPresent(s -> {
            String caption = ((Component)s.getField()).getCaption();
            Notification.show((String)caption, (String)((String)s.getMessage().get()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
        });
    }

    public boolean onBack() {
        return true;
    }
}

