/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui.steps.net;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.data.converter.StringToIntegerConverter;
import com.vaadin.data.validator.IntegerRangeValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.model.NetworkConfigurationModel;
import org.openthinclient.wizard.ui.steps.net.HostnameValidator;

public class ProxyConfigurationForm
extends CustomComponent {
    private static final long serialVersionUID = -120512201002490319L;
    private final TextField hostField;
    private final TextField portField;
    private final TextField userField;
    private final PasswordField passwordField;
    private final CheckBox authenticationCheckbox;
    private final Binder<NetworkConfiguration.ProxyConfiguration> binder;
    private final NetworkConfigurationModel networkConfigurationModel;

    public ProxyConfigurationForm(NetworkConfigurationModel networkConfigurationModel) {
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.networkConfigurationModel = networkConfigurationModel;
        this.authenticationCheckbox = new CheckBox(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_PROXY_CONNECTION_AUTH, new Object[0]));
        this.binder = new Binder();
        this.userField = new TextField("Username");
        this.userField.setPlaceholder("Username");
        this.passwordField = new PasswordField("Password");
        this.passwordField.setPlaceholder("Password");
        this.binder.forField((HasValue)this.userField).withNullRepresentation((Object)"").bind(NetworkConfiguration.ProxyConfiguration::getUser, NetworkConfiguration.ProxyConfiguration::setUser);
        this.binder.forField((HasValue)this.passwordField).withNullRepresentation((Object)"").bind(NetworkConfiguration.ProxyConfiguration::getPassword, NetworkConfiguration.ProxyConfiguration::setPassword);
        this.hostField = new TextField("Hostname");
        this.hostField.setPlaceholder("proxy.example.com");
        this.binder.forField((HasValue)this.hostField).withValidator((Validator)new StringLengthValidator(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_PROXY_CONNECTION_HOST_MISSING, new Object[0]), Integer.valueOf(1), null)).withValidator((Validator)new HostnameValidator(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_PROXY_CONNECTION_HOST_INVALID, new Object[0]))).withNullRepresentation((Object)"").bind(NetworkConfiguration.ProxyConfiguration::getHost, NetworkConfiguration.ProxyConfiguration::setHost);
        this.portField = new TextField("Port");
        this.binder.forField((HasValue)this.portField).withConverter((Converter)new StringToIntegerConverter(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_PROXY_CONNECTION_PORT_INVALID, new Object[0])){
            private static final long serialVersionUID = -6464686484330572080L;

            protected NumberFormat getFormat(Locale locale) {
                DecimalFormat format = new DecimalFormat();
                format.setMaximumFractionDigits(0);
                format.setDecimalSeparatorAlwaysShown(false);
                format.setParseIntegerOnly(true);
                format.setGroupingUsed(false);
                return format;
            }
        }).withValidator((Validator)new IntegerRangeValidator(mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_PROXY_CONNECTION_PORT_INVALID, new Object[0]), Integer.valueOf(1), Integer.valueOf(65535))).bind(NetworkConfiguration.ProxyConfiguration::getPort, NetworkConfiguration.ProxyConfiguration::setPort);
        this.binder.readBean((Object)networkConfigurationModel.getProxyConfiguration());
        FormLayout form = new FormLayout();
        form.addComponent((Component)this.hostField);
        form.addComponent((Component)this.portField);
        form.addComponent((Component)this.authenticationCheckbox);
        form.addComponent((Component)this.userField);
        form.addComponent((Component)this.passwordField);
        this.authenticationCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.updateEnabledState());
        this.updateEnabledState();
        this.setCompositionRoot((Component)form);
    }

    private void updateEnabledState() {
        this.hostField.setEnabled(this.isEnabled());
        this.portField.setEnabled(this.isEnabled());
        boolean userEditEnabled = this.isEnabled() && this.authenticationCheckbox.getValue() != false;
        this.userField.setEnabled(userEditEnabled);
        this.passwordField.setEnabled(userEditEnabled);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnabledState();
    }

    public void commit() {
        this.binder.writeBeanIfValid((Object)this.networkConfigurationModel.getProxyConfiguration());
    }
}

