/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import net.sf.ehcache.CacheException;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static ClassLoader getStandardClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Object createNewInstance(String className) throws CacheException {
        Object newInstance;
        try {
            Class<?> clazz = Class.forName(className, true, ClassLoaderUtil.getStandardClassLoader());
            newInstance = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e.getMessage(), e);
        }
        return newInstance;
    }
}

