/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.mountd;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.openthinclient.mountd.Exporter;
import org.openthinclient.service.nfs.NFSExport;

public class ListExporter
implements Exporter {
    private final List<NFSExport> exports = new ArrayList<NFSExport>();

    public ListExporter() {
        this(null);
    }

    public ListExporter(NFSExport[] exports2) {
        if (null != exports2) {
            for (int i = 0; i < exports2.length; ++i) {
                this.exports.add(exports2[i]);
            }
        }
    }

    @Override
    public NFSExport getExport(InetAddress peer, String mountRequest) {
        String mountRequestNormalized = "";
        String exportNameNormalized = "";
        try {
            mountRequestNormalized = new File(mountRequest).getCanonicalPath();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        for (NFSExport export : this.exports) {
            try {
                exportNameNormalized = new File(export.getName()).getCanonicalPath();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (exportNameNormalized.equals(mountRequestNormalized)) {
                return export;
            }
            if (!mountRequestNormalized.startsWith(exportNameNormalized)) continue;
            String subdir = mountRequestNormalized.substring(exportNameNormalized.length());
            String rootsubdir = export.getRoot() + subdir;
            if (!new File(rootsubdir).isDirectory()) continue;
            try {
                NFSExport subexport = export.clone();
                subexport.setName(mountRequestNormalized);
                subexport.setRoot(new File(rootsubdir));
                return subexport;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public List<NFSExport> getExports() {
        return this.exports;
    }

    public void addExport(NFSExport e) {
        for (NFSExport existing : this.exports) {
            if (!existing.getName().equals(e.getName())) continue;
            throw new IllegalArgumentException("There is already an export with this name");
        }
        this.exports.add(e);
    }

    public boolean removeExport(String share) {
        for (NFSExport existing : this.exports) {
            if (!existing.getName().equals(share)) continue;
            existing.setRevoked(true);
            this.exports.remove(existing);
            return true;
        }
        return false;
    }
}

