/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.mountd;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.acplt.oncrpc.OncRpcException;
import org.openthinclient.mountd.Exporter;
import org.openthinclient.mountd.tea.MountDaemonStub;
import org.openthinclient.mountd.tea.dirpath;
import org.openthinclient.mountd.tea.exportnode;
import org.openthinclient.mountd.tea.exports;
import org.openthinclient.mountd.tea.fhandle;
import org.openthinclient.mountd.tea.fhstatus;
import org.openthinclient.mountd.tea.groupnode;
import org.openthinclient.mountd.tea.groups;
import org.openthinclient.mountd.tea.mountlist;
import org.openthinclient.mountd.tea.name;
import org.openthinclient.nfsd.PathManager;
import org.openthinclient.nfsd.StaleHandleException;
import org.openthinclient.nfsd.tea.nfs_fh;
import org.openthinclient.service.nfs.NFSExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountDaemon
extends MountDaemonStub {
    private static final Logger LOG = LoggerFactory.getLogger(MountDaemon.class);
    private final PathManager pathManager;
    private Exporter exporter;

    public MountDaemon(PathManager pathManager, Exporter exports2, int mountdPort, int mountdProgramNumber) throws OncRpcException, IOException {
        super(mountdPort, mountdProgramNumber);
        this.pathManager = pathManager;
        this.exporter = exports2;
    }

    @Override
    protected void MOUNTPROC_NULL_1() {
        LOG.debug("NULL");
    }

    @Override
    protected fhstatus MOUNTPROC_MNT_1(InetAddress peer, dirpath params) {
        LOG.debug("MNT: " + params.value);
        NFSExport export = this.exporter.getExport(peer, params.value.trim());
        fhstatus ret = new fhstatus();
        if (null == export) {
            LOG.warn("MOUNT: export not found for " + params.value);
            ret.fhs_status = 2;
            return ret;
        }
        try {
            nfs_fh fh = this.pathManager.getHandleForExport(export);
            ret.fhs_fhandle = new fhandle(fh.data);
        }
        catch (StaleHandleException e) {
            LOG.error("Got StaleHandleException during mount. Should not happen.");
            ret.fhs_status = 5;
        }
        return ret;
    }

    @Override
    protected mountlist MOUNTPROC_DUMP_1() {
        LOG.debug("DUMP");
        return null;
    }

    @Override
    protected void MOUNTPROC_UMNT_1(dirpath params) {
        LOG.debug("UMNT");
    }

    @Override
    protected void MOUNTPROC_UMNTALL_1() {
        LOG.debug("UMNTALL");
    }

    @Override
    protected exports MOUNTPROC_EXPORT_1() {
        exports ret;
        LOG.debug("EXPORT");
        exports tail = ret = new exports();
        List<NFSExport> exports2 = this.exporter.getExports();
        for (NFSExport exp : exports2) {
            exports export = new exports(new exportnode());
            export.value.ex_dir = new dirpath(exp.getName());
            List<NFSExport.Group> groups2 = exp.getGroups();
            if (null != groups2) {
                export.value.ex_groups = new groups();
                for (NFSExport.Group group : groups2) {
                    groups g = new groups(new groupnode());
                    g.value.gr_next = export.value.ex_groups;
                    export.value.ex_groups = g;
                    if (group.isWildcard()) {
                        g.value.gr_name = new name("*");
                        continue;
                    }
                    g.value.gr_name = new name(group.getAddress() + "/" + Integer.toString(group.getMask()));
                }
            } else {
                export.value.ex_groups = new groups(new groupnode());
                export.value.ex_groups.value.gr_name = new name("*");
                export.value.ex_groups.value.gr_next = new groups();
            }
            tail.value = export.value;
            tail.value.ex_next = export;
            export.value = null;
            tail = export;
        }
        return ret;
    }

    @Override
    protected exports MOUNTPROC_EXPORTALL_1() {
        return this.MOUNTPROC_EXPORT_1();
    }

    public Exporter getExporter() {
        return this.exporter;
    }

    public void setExporter(Exporter exports2) {
        this.exporter = exports2;
    }
}

