/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.nfsd;

import com.levigo.util.collections.IntHashtable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openthinclient.mountd.Exporter;
import org.openthinclient.nfsd.NFSFile;
import org.openthinclient.nfsd.NFSServer;
import org.openthinclient.nfsd.StaleHandleException;
import org.openthinclient.nfsd.tea.nfs_fh;
import org.openthinclient.service.nfs.NFSExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathManager {
    static final Logger LOG = LoggerFactory.getLogger(PathManager.class);
    private final File handleDatabase;
    private final IntHashtable handlesToFiles;
    private final Map<File, nfs_fh> filesToHandles;
    private boolean isChanged;
    private final byte[] handleGeneration;
    private int currentHandleCounter = 0;
    private final Exporter exporter;

    public PathManager(File handleDatabase, Exporter exporter) throws IOException {
        this.handleDatabase = handleDatabase;
        this.exporter = exporter;
        this.handlesToFiles = new IntHashtable();
        this.filesToHandles = new HashMap<File, nfs_fh>();
        this.isChanged = true;
        this.handleGeneration = new byte[8];
        long currentTimeMillis = System.currentTimeMillis();
        this.handleGeneration[0] = (byte)(currentTimeMillis >> 56 & 0xFFL | 1L);
        this.handleGeneration[1] = (byte)(currentTimeMillis >> 48 & 0xFFL);
        this.handleGeneration[2] = (byte)(currentTimeMillis >> 40 & 0xFFL);
        this.handleGeneration[3] = (byte)(currentTimeMillis >> 32 & 0xFFL);
        this.handleGeneration[4] = (byte)(currentTimeMillis >> 24 & 0xFFL);
        this.handleGeneration[5] = (byte)(currentTimeMillis >> 16 & 0xFFL);
        this.handleGeneration[6] = (byte)(currentTimeMillis >> 8 & 0xFFL);
        this.handleGeneration[7] = (byte)(currentTimeMillis & 0xFFL);
        this.loadPathDatabase();
    }

    private void loadPathDatabase() throws IOException {
        if (null != this.handleDatabase) {
            if (this.handleDatabase.exists() && !this.handleDatabase.canWrite()) {
                throw new IOException("The handle database must be writable.");
            }
            File tmp = File.createTempFile("paths", ".db", this.handleDatabase.getAbsoluteFile().getParentFile());
            if (null == tmp) {
                throw new IOException("Can't create tmp handle database at " + tmp);
            }
            tmp.delete();
            if (this.handleDatabase.exists()) {
                String line;
                LOG.info("Loading path database at " + this.handleDatabase);
                List<NFSExport> exports2 = this.exporter.getExports();
                BufferedReader br = new BufferedReader(new FileReader(this.handleDatabase));
                while (null != (line = br.readLine())) {
                    try {
                        nfs_fh fh = new nfs_fh(new byte[32]);
                        PathManager.parseHex(line, 0, fh.data, 12);
                        File path = new File(line.substring(25));
                        if (!path.exists() && !path.isHidden()) {
                            if (!LOG.isInfoEnabled()) continue;
                            LOG.info("Not loading nonexistent path " + path);
                            continue;
                        }
                        NFSExport bestMatch = null;
                        int bestLength = 0;
                        for (NFSExport export : exports2) {
                            String exportRoot = export.getRoot().getAbsolutePath();
                            if (!path.getAbsolutePath().startsWith(exportRoot) || exportRoot.length() <= bestLength) continue;
                            bestMatch = export;
                            bestLength = exportRoot.length();
                        }
                        if (null == bestMatch) {
                            if (!LOG.isInfoEnabled()) continue;
                            LOG.info("Path seems to be no longer exported: " + path);
                            continue;
                        }
                        int id = PathManager.handleToInt(fh);
                        this.currentHandleCounter = Math.max(this.currentHandleCounter, id + 1);
                        this.handlesToFiles.put(id, (Object)new NFSFile(fh, path, null, bestMatch));
                        this.filesToHandles.put(path, fh);
                    }
                    catch (Exception e) {
                        LOG.warn("Can't parse this line: " + line);
                    }
                }
                ArrayList<NFSFile> filesToRemove = new ArrayList<NFSFile>();
                Enumeration i = this.handlesToFiles.elements();
                while (i.hasMoreElements()) {
                    NFSFile file = (NFSFile)i.nextElement();
                    File parent = file.getFile().getParentFile();
                    nfs_fh parentHandle = this.filesToHandles.get(parent);
                    if (null == parentHandle && !file.getFile().equals(file.getExport().getRoot())) {
                        LOG.warn("Parent for file " + file.getFile() + " not found in handle database.");
                        filesToRemove.add(file);
                        continue;
                    }
                    if (null == parentHandle) continue;
                    NFSFile parentFile = (NFSFile)this.handlesToFiles.get(PathManager.handleToInt(parentHandle));
                    if (null == parentFile) {
                        LOG.warn("Parent file for handle not found. Should not happen!");
                        filesToRemove.add(file);
                        continue;
                    }
                    file.setParentDirectory(parentFile);
                }
                for (NFSFile file : filesToRemove) {
                    this.filesToHandles.remove(file.getFile());
                    this.handlesToFiles.remove(PathManager.handleToInt(file.getHandle()));
                }
                this.isChanged = false;
            }
        }
    }

    public synchronized void flushPathDatabase() throws IOException {
        if (null != this.handleDatabase && this.isChanged) {
            if (this.handleDatabase.exists() && !this.handleDatabase.canWrite()) {
                throw new IOException("The handle database must be writable.");
            }
            File tmp = File.createTempFile("paths", ".db", this.handleDatabase.getParentFile());
            if (null == tmp) {
                throw new IOException("Can't create tmp handle database at " + tmp);
            }
            LOG.info("Saving path database at " + this.handleDatabase);
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
            Enumeration i = this.handlesToFiles.elements();
            while (i.hasMoreElements()) {
                NFSFile file = (NFSFile)i.nextElement();
                file.flushCache();
                this.toHex(file.getHandle().data, 0, 12, bw);
                bw.write(32);
                bw.write(file.getFile().getAbsolutePath());
                bw.write(10);
            }
            bw.close();
            File handleDBBackup = new File(this.handleDatabase.getAbsolutePath() + "~");
            handleDBBackup.delete();
            this.handleDatabase.renameTo(handleDBBackup);
            tmp.renameTo(this.handleDatabase);
            this.isChanged = false;
        }
    }

    private void toHex(byte[] bs, int offset, int length, BufferedWriter bw) throws IOException {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            bw.write(this.intToChar(bs[i] >> 4 & 0xF));
            bw.write(this.intToChar(bs[i] & 0xF));
        }
    }

    private char intToChar(int i) {
        if (i >= 0 && i <= 9) {
            return (char)(i + 48);
        }
        if (i >= 10 && i <= 15) {
            return (char)(i + 97 - 10);
        }
        throw new IllegalArgumentException();
    }

    private static void parseHex(String line, int start, byte[] bytes, int length) {
        int charIdx = start;
        int i = 0;
        while (i < length) {
            bytes[i] = (byte)(PathManager.charToInt(line.charAt(charIdx++)) << 4);
            int n = i++;
            bytes[n] = (byte)(bytes[n] | (byte)PathManager.charToInt(line.charAt(charIdx++)));
        }
    }

    private static int charToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new NumberFormatException("Illegal hex character " + c);
    }

    static int handleToInt(nfs_fh handle) {
        byte[] h = handle.data;
        return (0xFF & h[8]) << 24 | (0xFF & h[9]) << 16 | (0xFF & h[10]) << 8 | 0xFF & h[11];
    }

    public NFSFile getNFSFileByHandle(nfs_fh fh) throws StaleHandleException {
        NFSFile nfsFile = (NFSFile)this.handlesToFiles.get(PathManager.handleToInt(fh));
        if (null == nfsFile) {
            throw new StaleHandleException();
        }
        if (!nfsFile.validateHandle(fh)) {
            throw new StaleHandleException("Handle was defined, but wrong generation");
        }
        nfsFile.updateTimestamp();
        return nfsFile;
    }

    public synchronized boolean handleForFileExists(File f) {
        return this.filesToHandles.get(f) != null;
    }

    public synchronized nfs_fh getHandleByFile(File f) throws StaleHandleException {
        nfs_fh handle;
        if (!f.isAbsolute()) {
            f = f.getAbsoluteFile();
        }
        if (null == (handle = this.filesToHandles.get(f))) {
            handle = this.createHandleForFile(f, null);
            this.filesToHandles.put(f, handle);
            this.isChanged = true;
        }
        return handle;
    }

    public synchronized int getIDByFile(File f) throws StaleHandleException {
        nfs_fh handle = this.filesToHandles.get(f);
        if (null == handle) {
            handle = this.createHandleForFile(f, null);
            this.filesToHandles.put(f, handle);
            this.isChanged = true;
        }
        return PathManager.getIDFromHandle(handle);
    }

    private static int getIDFromHandle(nfs_fh handle) {
        return NFSServer.byteToInt(handle.data, 8);
    }

    private nfs_fh createHandleForFile(File f, NFSExport export) throws StaleHandleException {
        nfs_fh fh = new nfs_fh(new byte[32]);
        System.arraycopy(this.handleGeneration, 0, fh.data, 0, 8);
        int h = this.currentHandleCounter++;
        fh.data[8] = (byte)(h >> 24 & 0xFF);
        fh.data[9] = (byte)(h >> 16 & 0xFF);
        fh.data[10] = (byte)(h >> 8 & 0xFF);
        fh.data[11] = (byte)(h & 0xFF);
        if (null == export) {
            File parentFile = f.getParentFile();
            nfs_fh parentHandle = this.filesToHandles.get(parentFile);
            if (null == parentHandle) {
                throw new StaleHandleException(f + " doesn't have a parent handle");
            }
            int id = PathManager.getIDFromHandle(parentHandle);
            NFSFile parent = (NFSFile)this.handlesToFiles.get(id);
            if (null == parent) {
                throw new StaleHandleException("Not NFS file for parent handle for " + f);
            }
            this.handlesToFiles.put(h, (Object)new NFSFile(fh, f, parent, parent.getExport()));
        } else {
            this.handlesToFiles.put(h, (Object)new NFSFile(fh, f, null, export));
        }
        this.isChanged = true;
        return fh;
    }

    public nfs_fh getHandleForExport(NFSExport e) throws StaleHandleException {
        nfs_fh handle;
        File root = e.getRoot();
        if (!root.isAbsolute()) {
            root = root.getAbsoluteFile();
        }
        if (null == (handle = this.filesToHandles.get(root))) {
            handle = this.createHandleForFile(root, e);
            this.filesToHandles.put(root, handle);
            this.isChanged = true;
        }
        return handle;
    }

    public synchronized void purgeFileAndHandle(File f) throws StaleHandleException {
        if (!f.isAbsolute()) {
            f = f.getAbsoluteFile();
        }
        this.handlesToFiles.remove(this.getIDByFile(f));
        this.filesToHandles.remove(f);
    }

    public synchronized void movePath(File from, File to) {
        LinkedHashMap<File, File> moveMap = new LinkedHashMap<File, File>();
        LinkedHashMap<File, File> recursiveMoveMap = this.getMoveMap(from, to, moveMap);
        for (Map.Entry<File, File> pairs : recursiveMoveMap.entrySet()) {
            this.moveMapEntries(pairs.getKey(), pairs.getValue());
        }
        this.isChanged = true;
    }

    private synchronized LinkedHashMap<File, File> getMoveMap(File from, File to, LinkedHashMap<File, File> sortedMoveMap) {
        nfs_fh fh;
        if (!from.isAbsolute()) {
            from = from.getAbsoluteFile();
        }
        if (!to.isAbsolute()) {
            to = to.getAbsoluteFile();
        }
        if (null != (fh = this.filesToHandles.get(to))) {
            this.filesToHandles.remove(to);
            this.handlesToFiles.remove(PathManager.handleToInt(fh));
        }
        sortedMoveMap.put(from, to);
        if (to.isDirectory()) {
            for (File f : this.filesToHandles.keySet()) {
                if (!f.getParentFile().equals(from)) continue;
                File t = new File(to, f.getName());
                this.getMoveMap(f, t, sortedMoveMap);
                sortedMoveMap.put(f, t);
            }
        }
        return sortedMoveMap;
    }

    private synchronized void moveMapEntries(File from, File to) {
        nfs_fh fhFrom = this.filesToHandles.get(from);
        if (null == fhFrom) {
            try {
                fhFrom = this.getHandleByFile(from);
            }
            catch (StaleHandleException e1) {
                e1.printStackTrace();
            }
        }
        if (null != fhFrom) {
            this.filesToHandles.remove(from);
            NFSFile nfsFileFrom = (NFSFile)this.handlesToFiles.get(PathManager.handleToInt(fhFrom));
            File parentFileTo = to.getParentFile();
            nfs_fh parentHandleTo = this.filesToHandles.get(parentFileTo);
            if (null == parentHandleTo) {
                try {
                    parentHandleTo = this.getHandleByFile(to.getParentFile());
                }
                catch (StaleHandleException e) {
                    e.printStackTrace();
                }
            }
            if (null != parentHandleTo) {
                int id = PathManager.getIDFromHandle(parentHandleTo);
                NFSFile parentTo = (NFSFile)this.handlesToFiles.get(id);
                if (null != parentTo) {
                    NFSFile nfsFileTo = new NFSFile(nfsFileFrom.getHandle(), to, parentTo, parentTo.getExport());
                    this.filesToHandles.put(to, fhFrom);
                    this.handlesToFiles.put(PathManager.handleToInt(fhFrom), (Object)nfsFileTo);
                } else {
                    LOG.warn("missing handle->file map for parentHandleTo: " + parentHandleTo);
                }
            } else {
                LOG.warn("missing file->handle map for parentFileTo: " + parentFileTo);
            }
            this.isChanged = true;
        } else {
            LOG.warn("missing file->handle map for from: " + from);
        }
    }

    public synchronized void shutdown() throws Exception {
        this.isChanged = true;
        this.flushPathDatabase();
    }

    public void flushFile(File f) {
        try {
            nfs_fh fh;
            if (!f.isAbsolute()) {
                f = f.getAbsoluteFile();
            }
            if (null != (fh = this.filesToHandles.get(f))) {
                NFSFile nfsFile = this.getNFSFileByHandle(fh);
                nfsFile.flushCache();
            }
        }
        catch (Exception e) {
            LOG.error("Unable to flush cache for: " + f.getAbsolutePath());
        }
    }

    public boolean createMissigHandles(File f) {
        File firstParent;
        if (!f.isAbsolute()) {
            f = f.getAbsoluteFile();
        }
        if (f.isFile()) {
            f = f.getParentFile();
        }
        if (this.handleForFileExists(f)) {
            return true;
        }
        LinkedList<File> filesToAdd = new LinkedList<File>();
        for (firstParent = f; !this.handleForFileExists(firstParent) && null != firstParent; firstParent = firstParent.getParentFile()) {
            filesToAdd.addFirst(firstParent);
        }
        if (null == firstParent) {
            LOG.error("Unable to get any parent of: " + f);
            return false;
        }
        try {
            NFSExport export = this.getNFSFileByHandle(this.getHandleByFile(firstParent)).getExport();
            for (File fileToAdd : filesToAdd) {
                nfs_fh fileToAddParentNfsHandle = this.getHandleByFile(fileToAdd.getParentFile());
                new NFSFile(this.getHandleByFile(fileToAdd), fileToAdd, this.getNFSFileByHandle(fileToAddParentNfsHandle), export);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean removeFileFromNFS(Collection<File> filesList) {
        for (File file : filesList) {
            this.flushFile(file);
            if (file.delete()) {
                if (!this.handleForFileExists(file)) continue;
                try {
                    if (!file.isAbsolute()) {
                        file = file.getAbsoluteFile();
                    }
                    this.handlesToFiles.remove(this.getIDByFile(file));
                    this.filesToHandles.remove(file);
                }
                catch (StaleHandleException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!file.isFile()) continue;
            LOG.error("Unable to remove File: " + file.getPath());
            return false;
        }
        this.isChanged = true;
        return true;
    }
}

