/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.nfs;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openthinclient.service.nfs.NFSExport;

public class ExportsParser {
    public NFSExport parse(String spec) throws UnknownHostException {
        String[] parts = spec.split("\\|");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Can't parse export spec: " + spec);
        }
        NFSExport export = new NFSExport();
        export.setName(parts[1]);
        export.setRoot(new File(parts[0]));
        Pattern p = Pattern.compile("([^\\s(]+)\\(([^\\s]+)\\)");
        for (int i = 2; i < parts.length; ++i) {
            String opts;
            Matcher m = p.matcher(parts[i]);
            if (!m.matches()) {
                throw new IllegalArgumentException("Can't parse export spec: " + spec);
            }
            NFSExport.Group g = new NFSExport.Group();
            if (null != m.group(1) && m.group(1).length() > 0 && m.group(1).equals("*")) {
                g.setWildcard(true);
            } else if (null != m.group(1) && m.group(1).length() > 0 && !m.group(1).equals("*")) {
                String[] addrAndMask = m.group(1).split("/");
                switch (addrAndMask.length) {
                    case 2: {
                        g.setAddress(InetAddress.getByName(addrAndMask[0]));
                        g.setMask(Integer.parseInt(addrAndMask[1]));
                        break;
                    }
                    case 1: {
                        g.setAddress(InetAddress.getByName(addrAndMask[0]));
                        g.setMask(0);
                        break;
                    }
                }
            }
            if (null != m.group(2) && m.group(2).length() > 0 && (opts = m.group(2).toLowerCase()).indexOf("ro") >= 0) {
                g.setReadOnly(true);
            }
            export.getGroups().add(g);
        }
        return export;
    }
}

