/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class LazyList<T>
extends AbstractList<T>
implements Serializable {
    private static final long serialVersionUID = 2423832460602269469L;
    private PagingProvider<T> pageProvider;
    private final CountProvider countProvider;
    public static final int DEFAULT_PAGE_SIZE = 45;
    private int maxPages = 3;
    List<List<T>> pages = new ArrayList<List<T>>();
    private int pageIndex = -10;
    private final int pageSize;
    private Integer cachedSize;
    private transient WeakHashMap<T, Integer> indexCache;

    private List<T> findPageFromCache(int pageIndexForReqest) {
        int p = pageIndexForReqest - this.pageIndex;
        if (p < 0) {
            return null;
        }
        if (this.pages.size() <= p) {
            return null;
        }
        return this.pages.get(p);
    }

    private void loadPreviousPage() {
        --this.pageIndex;
        List<T> page = this.findEntities(this.pageIndex * this.pageSize);
        this.pages.add(0, page);
        if (this.pages.size() > this.maxPages) {
            this.pages.remove(this.pages.size() - 1);
        }
    }

    private void loadNextPage() {
        List<T> page = this.findEntities((this.pageIndex + this.pages.size()) * this.pageSize);
        this.pages.add(page);
        if (this.pages.size() > this.maxPages) {
            this.pages.remove(0);
            ++this.pageIndex;
        }
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public void setMaxPages(int maxPages) {
        this.maxPages = maxPages;
    }

    protected LazyList(CountProvider countProvider, int pageSize) {
        this.countProvider = countProvider;
        this.pageSize = pageSize;
    }

    public LazyList(EntityProvider<T> dataProvider) {
        this(dataProvider, 45);
    }

    public LazyList(EntityProvider<T> dataProvider, int pageSize) {
        this.pageProvider = dataProvider;
        this.countProvider = dataProvider;
        this.pageSize = pageSize;
    }

    public LazyList(PagingProvider<T> pageProvider, CountProvider countProvider) {
        this(pageProvider, countProvider, 45);
    }

    public LazyList(PagingProvider<T> pageProvider, CountProvider countProvider, int pageSize) {
        this.pageProvider = pageProvider;
        this.countProvider = countProvider;
        this.pageSize = pageSize;
    }

    @Override
    public T get(int index) {
        int pageIndexForReqest = index / this.pageSize;
        int indexOnPage = index % this.pageSize;
        List<T> page = this.findPageFromCache(pageIndexForReqest);
        if (page == null) {
            if (this.pageIndex >= 0) {
                if (pageIndexForReqest > this.pageIndex && pageIndexForReqest < this.pageIndex + this.pages.size() + this.maxPages) {
                    while (pageIndexForReqest >= this.pageIndex + this.pages.size()) {
                        this.loadNextPage();
                    }
                } else if (pageIndexForReqest < this.pageIndex && pageIndexForReqest > this.pageIndex - this.maxPages) {
                    while (pageIndexForReqest < this.pageIndex) {
                        this.loadPreviousPage();
                    }
                } else {
                    this.initCacheFormPage(pageIndexForReqest);
                }
            } else {
                this.initCacheFormPage(pageIndexForReqest);
            }
            page = this.findPageFromCache(pageIndexForReqest);
        }
        return page != null ? (T)page.get(indexOnPage) : null;
    }

    protected void initCacheFormPage(int pageIndexForReqest) {
        this.pageIndex = pageIndexForReqest;
        this.pages.clear();
        this.pages.add(this.findEntities(this.pageIndex * this.pageSize));
    }

    protected List<T> findEntities(int i) {
        return this.pageProvider.findEntities(i);
    }

    @Override
    public int size() {
        if (this.cachedSize == null) {
            this.cachedSize = this.countProvider.size();
        }
        return this.cachedSize;
    }

    private Map<T, Integer> getIndexCache() {
        if (this.indexCache == null) {
            this.indexCache = new WeakHashMap();
        }
        return this.indexCache;
    }

    @Override
    public int indexOf(Object o) {
        Integer indexViaCache = this.getIndexCache().get(o);
        if (indexViaCache != null) {
            return indexViaCache;
        }
        for (int i = 0; i < this.pages.size(); ++i) {
            List<T> page = this.pages.get(i);
            int indexOf = page.indexOf(o);
            if (indexOf == -1) continue;
            indexViaCache = (this.pageIndex + i) * this.pageSize + indexOf;
        }
        if (indexViaCache != null) {
            this.getIndexCache().put(o, indexViaCache);
            return indexViaCache;
        }
        return super.indexOf(o);
    }

    @Override
    public boolean contains(Object o) {
        if (this.getIndexCache().containsKey(o)) {
            return true;
        }
        for (List<T> t : this.pages) {
            if (!t.contains(o)) continue;
            return true;
        }
        return super.contains(o);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        int sizeOfSublist = toIndex - fromIndex;
        if (sizeOfSublist > this.maxPages * (this.pageSize - 1)) {
            this.maxPages = sizeOfSublist / this.pageSize + 1;
        }
        return new ArrayList(super.subList(fromIndex, toIndex));
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = -1;
            private final int size = LazyList.this.size();

            @Override
            public boolean hasNext() {
                return this.index + 1 < this.size;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.index;
                return LazyList.this.get(this.index);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public void reset() {
        this.pages.clear();
        this.pageIndex = -10;
        this.cachedSize = null;
        if (this.indexCache != null) {
            this.indexCache.clear();
        }
    }

    public static interface EntityProvider<T>
    extends PagingProvider<T>,
    CountProvider {
    }

    public static interface CountProvider
    extends Serializable {
        public int size();
    }

    public static interface PagingProvider<T>
    extends Serializable {
        public List<T> findEntities(int var1);
    }
}

