/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.button;

import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Button;
import java.util.LinkedHashSet;
import org.vaadin.dialogs.ConfirmDialog;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.fluency.ui.FluentAbstractComponent;

public class ConfirmButton
extends Button
implements FluentAbstractComponent<ConfirmButton> {
    private static final long serialVersionUID = -3146998691761708825L;
    private String confirmWindowCaption;
    private String confirmationText = "Are you sure?";
    private String okCaption = "OK";
    private String cancelCaption = "Cancel";
    private String confirmWindowOkButtonStyle;
    private LinkedHashSet<MButton.MClickListener> mClickListeners;

    public ConfirmButton() {
    }

    public ConfirmButton(String buttonCaption, String confirmationText, Button.ClickListener listener) {
        super(buttonCaption, listener);
        this.confirmationText = confirmationText;
    }

    public ConfirmButton(Resource icon, String confirmationText, MButton.MClickListener listener) {
        super(icon);
        this.addClickListener(listener);
        this.confirmationText = confirmationText;
    }

    public ConfirmButton(Resource icon, String buttonCaption, String confirmationText, MButton.MClickListener listener) {
        super(buttonCaption, icon);
        this.addClickListener(listener);
        this.confirmationText = confirmationText;
    }

    public ConfirmButton addClickListener(MButton.MClickListener listener) {
        if (this.mClickListeners == null) {
            this.mClickListeners = new LinkedHashSet();
        }
        this.mClickListeners.add(listener);
        return this;
    }

    public ConfirmButton removeClickListener(MButton.MClickListener listener) {
        if (this.mClickListeners != null) {
            this.mClickListeners.remove(listener);
        }
        return this;
    }

    protected void fireClick(final MouseEventDetails details) {
        ConfirmDialog dialog = ConfirmDialog.show(this.getUI(), this.getConfirmWindowCaption(), this.getConfirmationText(), this.getOkCaption(), this.getCancelCaption(), new Runnable(){

            @Override
            public void run() {
                ConfirmButton.this.doFireClickListener(details);
            }
        });
        dialog.getOkButton().addStyleName(this.confirmWindowOkButtonStyle);
    }

    protected void fireClick() {
        this.fireClick(null);
    }

    public void setClickShortcut(int keyCode, int ... modifiers) {
        super.setClickShortcut(keyCode, modifiers);
    }

    protected void doFireClickListener(MouseEventDetails details) {
        ConfirmButton.super.fireClick(details);
        if (this.mClickListeners != null) {
            MButton.MClickListener[] array;
            for (MButton.MClickListener l : array = this.mClickListeners.toArray(new MButton.MClickListener[this.mClickListeners.size()])) {
                l.onClick();
            }
        }
    }

    public String getConfirmWindowCaption() {
        return this.confirmWindowCaption;
    }

    public ConfirmButton setConfirmWindowCaption(String confirmWindowCaption) {
        this.confirmWindowCaption = confirmWindowCaption;
        return this;
    }

    public String getConfirmationText() {
        return this.confirmationText;
    }

    public ConfirmButton setConfirmationText(String confirmationText) {
        this.confirmationText = confirmationText;
        return this;
    }

    public String getOkCaption() {
        return this.okCaption;
    }

    public ConfirmButton setOkCaption(String okCaption) {
        this.okCaption = okCaption;
        return this;
    }

    public String getCancelCaption() {
        return this.cancelCaption;
    }

    public ConfirmButton setCancelCaption(String cancelCaption) {
        this.cancelCaption = cancelCaption;
        return this;
    }

    public ConfirmButton withI18NCaption(String okCaption, String cancelCaption) {
        this.okCaption = okCaption;
        this.cancelCaption = cancelCaption;
        return this;
    }

    public void setConfirmWindowOkButtonStyle(String confirmWindowOkButtonStyle) {
        this.confirmWindowOkButtonStyle = confirmWindowOkButtonStyle;
    }
}

