/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.components;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.FontIcon;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.layouts.MVerticalLayout;

public class DisclosurePanel
extends VerticalLayout {
    private static final long serialVersionUID = 6509419456771505782L;
    private FontIcon closedIcon = VaadinIcons.PLUS_CIRCLE;
    private FontIcon openIcon = VaadinIcons.MINUS_CIRCLE;
    private final MButton toggle = new MButton((Resource)this.closedIcon);
    private final MVerticalLayout contentWrapper = new MVerticalLayout();

    public DisclosurePanel() {
        this.setMargin(false);
        this.setSpacing(false);
        this.toggle.setStyleName("borderless");
        this.contentWrapper.setVisible(false);
        this.addComponents(new Component[]{this.toggle, this.contentWrapper});
        this.toggle.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -3471451934465654395L;

            public void buttonClick(Button.ClickEvent event) {
                DisclosurePanel.this.setOpen(!DisclosurePanel.this.isOpen());
            }
        });
    }

    public DisclosurePanel(String caption, Component ... content) {
        this();
        this.setCaption(caption);
        this.contentWrapper.add(content);
    }

    public boolean isOpen() {
        return this.contentWrapper.isVisible();
    }

    public DisclosurePanel setOpen(boolean open) {
        this.contentWrapper.setVisible(open);
        this.toggle.setIcon((Resource)(open ? this.getOpenIcon() : this.getClosedIcon()));
        return this;
    }

    public DisclosurePanel setContent(Component ... content) {
        this.contentWrapper.removeAllComponents();
        this.contentWrapper.add(content);
        return this;
    }

    public void setCaption(String caption) {
        this.toggle.setCaption(caption);
    }

    public MVerticalLayout getContentWrapper() {
        return this.contentWrapper;
    }

    public FontIcon getClosedIcon() {
        return this.closedIcon;
    }

    public DisclosurePanel setClosedIcon(FontIcon closedIcon) {
        this.closedIcon = closedIcon;
        return this.setOpen(this.isOpen());
    }

    public FontIcon getOpenIcon() {
        return this.openIcon;
    }

    public DisclosurePanel setOpenIcon(FontIcon openIcon) {
        this.openIcon = openIcon;
        return this.setOpen(this.isOpen());
    }
}

