/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.grid;

import com.vaadin.data.provider.DataCommunicator;
import com.vaadin.shared.Range;
import com.vaadin.shared.data.DataCommunicatorClientRpc;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SizelessPagingDataCommunicator<T>
extends DataCommunicator<T> {
    protected static final int CACHE_SIZE = 5;
    DataCommunicatorClientRpc rpc = (DataCommunicatorClientRpc)this.getRpcProxy(DataCommunicatorClientRpc.class);
    int knownSize = 0;
    private boolean useCache = true;
    private int pageSize = this.getMinPushSize() * 2;
    private Map<Integer, List<T>> pageCache = new LinkedHashMap(16, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 5;
        }
    };

    protected void sendDataToClient(boolean initial) {
        Range requestedRows;
        if (this.getDataProvider() == null) {
            return;
        }
        if (initial) {
            this.rpc.reset(0);
            if (this.reset) {
                this.reset = false;
            }
        }
        if (this.reset) {
            this.pageCache.clear();
            this.rpc.reset(this.getDataProviderSize());
            this.reset = false;
        }
        if (!(requestedRows = this.getPushRows()).isEmpty()) {
            int limit;
            List<T> rowsToPush;
            int offset = requestedRows.getStart();
            int lastIndex = offset + (rowsToPush = this.fetchItemsWithRange(offset, limit = requestedRows.length() + this.getMinPushSize())).size();
            if (lastIndex > this.knownSize) {
                int rowsToAdd = lastIndex - this.knownSize;
                this.rpc.insertRows(this.knownSize, rowsToAdd + (rowsToPush.size() == limit ? 1 : 0));
                this.knownSize = lastIndex;
            } else if (rowsToPush.size() < requestedRows.length()) {
                int rowsToRemove = Math.max(requestedRows.length() - rowsToPush.size(), this.knownSize - lastIndex);
                this.knownSize = lastIndex;
                this.rpc.removeRows(this.knownSize, rowsToRemove);
            }
            this.pushData(offset, rowsToPush);
        }
        if (!this.getUpdatedData().isEmpty()) {
            JsonArray dataArray = Json.createArray();
            int i = 0;
            for (Object data : this.getUpdatedData()) {
                dataArray.set(i++, (JsonValue)this.getDataObject(data));
            }
            this.rpc.updateData(dataArray);
        }
        this.setPushRows(Range.withLength((int)0, (int)0));
        this.getUpdatedData().clear();
    }

    public int getDataProviderSize() {
        return this.knownSize;
    }

    public List<T> fetchItemsWithRange(int offset, int limit) {
        int endPage;
        int pageSize = this.getPageSize();
        int startPage = (int)Math.floor((double)offset / (double)pageSize);
        if (startPage != (endPage = (int)Math.floor((double)(offset + limit - 1) / (double)pageSize))) {
            List<T> page0 = this.accessDataProvider(startPage * pageSize, pageSize);
            List<T> page1 = page0.size() < pageSize ? Collections.EMPTY_LIST : this.accessDataProvider(endPage * pageSize, pageSize);
            page0 = page0.subList(offset % pageSize, page0.size());
            page1 = page1.subList(0, Math.min(limit - page0.size(), page1.size()));
            ArrayList<T> result = new ArrayList<T>(page0);
            result.addAll(page1);
            return result;
        }
        List<T> page0 = this.accessDataProvider(startPage * pageSize, pageSize);
        int start = offset % pageSize;
        int end = Math.min(start + limit, page0.size());
        return page0.subList(start, end);
    }

    protected List<T> accessDataProvider(int offset, int limit) {
        if (this.useCache) {
            int page = offset / limit;
            return this.pageCache.computeIfAbsent(page, p -> super.fetchItemsWithRange(offset, limit));
        }
        return super.fetchItemsWithRange(offset, limit);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean isUseCache() {
        return this.useCache;
    }
}

