/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.dhcp;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.Enumeration;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.dhcp.BasePXEService;

public class BindToAddressPXEService
extends BasePXEService {
    public BindToAddressPXEService(RealmService realmService, ClientService clientService, UnrecognizedClientService unrecognizedClientService) throws DirectoryException {
        super(realmService, clientService, unrecognizedClientService);
    }

    @Override
    public void init(IoAcceptor acceptor, IoHandler handler, IoServiceConfig config) throws IOException {
        logger.warn("-------------------------------------------------------------");
        logger.warn("  Using BindToAddressPXEService implementation. ");
        logger.warn("  This type of service will not work on most UNIX systems.");
        logger.warn("  (for more details, see log messages with level INFO)");
        logger.info("");
        Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
        while (i.hasMoreElements()) {
            NetworkInterface nif = i.nextElement();
            Enumeration<InetAddress> j = nif.getInetAddresses();
            while (j.hasMoreElements()) {
                InetAddress address = j.nextElement();
                if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                InetSocketAddress dhcpPort = new InetSocketAddress(address, 67);
                acceptor.bind((SocketAddress)dhcpPort, handler, config);
                logger.info("Listening on " + dhcpPort);
                InetSocketAddress pxePort = new InetSocketAddress(address, 4011);
                acceptor.bind((SocketAddress)pxePort, handler, config);
                logger.info("Listening on " + pxePort);
            }
        }
        logger.warn("-------------------------------------------------------------");
    }
}

