/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.dhcp;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.apache.directory.server.dhcp.protocol.DhcpProtocolHandler;
import org.apache.directory.server.dhcp.service.DhcpService;
import org.apache.mina.common.ExecutorThreadModel;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.support.DatagramSessionConfigImpl;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.common.Service;
import org.openthinclient.service.dhcp.AbstractPXEService;
import org.openthinclient.service.dhcp.BindToAddressPXEService;
import org.openthinclient.service.dhcp.DhcpServiceConfiguration;
import org.openthinclient.service.dhcp.EavesdroppingPXEService;
import org.openthinclient.service.dhcp.SingleHomedBroadcastPXEService;
import org.openthinclient.service.dhcp.SingleHomedPXEService;
import org.openthinclient.services.Dhcp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHCPService
implements Service<DhcpServiceConfiguration>,
Dhcp {
    private static final Logger logger = LoggerFactory.getLogger(DHCPService.class);
    private final ClientService clientService;
    private final UnrecognizedClientService unrecognizedClientService;
    private final RealmService realmService;
    private IoAcceptor acceptor;
    private AbstractPXEService dhcpService;
    private IoAcceptorConfig config;
    private DhcpProtocolHandler handler;
    private DhcpServiceConfiguration configuration;

    public DHCPService(RealmService realmService, ClientService clientService, UnrecognizedClientService unrecognizedClientService) {
        this.realmService = realmService;
        this.clientService = clientService;
        this.unrecognizedClientService = unrecognizedClientService;
    }

    public DhcpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DhcpServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    public Class<DhcpServiceConfiguration> getConfigurationClass() {
        return DhcpServiceConfiguration.class;
    }

    public void startService() throws Exception {
        logger.info("Starting...");
        this.acceptor = new DatagramAcceptor();
        this.config = new DatagramAcceptorConfig();
        ((DatagramSessionConfigImpl)this.config.getSessionConfig()).setReuseAddress(true);
        ((DatagramSessionConfigImpl)this.config.getSessionConfig()).setBroadcast(true);
        ExecutorThreadModel threadModel = ExecutorThreadModel.getInstance((String)"DHCP");
        threadModel.setExecutor((Executor)new ThreadPoolExecutor(5, 5, 60L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue()));
        this.config.setThreadModel((ThreadModel)threadModel);
        this.dhcpService = this.createPXEService(this.config);
        this.dhcpService.setTrackUnrecognizedPXEClients(this.configuration.isTrackUnrecognizedPXEClients());
        this.dhcpService.setPolicy(this.configuration.getPxe().getPolicy());
        this.handler = new DhcpProtocolHandler((DhcpService)this.dhcpService);
        this.dhcpService.init(this.acceptor, (IoHandler)this.handler, (IoServiceConfig)this.config);
    }

    private AbstractPXEService createPXEService(IoAcceptorConfig config) throws DirectoryException {
        switch (this.configuration.getPxe().getType()) {
            case BIND_TO_ADDRESS: {
                return new BindToAddressPXEService(this.realmService, this.clientService, this.unrecognizedClientService);
            }
            case EAVESDROPPING: {
                return new EavesdroppingPXEService(this.realmService, this.clientService, this.unrecognizedClientService);
            }
            case SINGLE_HOMED_BROADCAST: {
                return new SingleHomedBroadcastPXEService(this.realmService, this.clientService, this.unrecognizedClientService);
            }
            case SINGLE_HOMED: {
                return new SingleHomedPXEService(this.realmService, this.clientService, this.unrecognizedClientService);
            }
        }
        return this.autodetectPXEService(config);
    }

    private AbstractPXEService autodetectPXEService(IoAcceptorConfig config) throws DirectoryException {
        logger.info("Auto-detecting the PXE service implementation to use");
        try {
            String osName = System.getProperty("os.name", "");
            if (osName.startsWith("Windows")) {
                logger.info("This seems to be Windows - going for the IndividualBind implementation");
                return new BindToAddressPXEService(this.realmService, this.clientService, this.unrecognizedClientService);
            }
        }
        catch (Exception e) {
            logger.info("Can't use BindToAddress implementation");
            logger.info("Falling back to the SingleHomed implementation");
            return new SingleHomedPXEService(this.realmService, this.clientService, this.unrecognizedClientService);
        }
        try {
            return new SingleHomedBroadcastPXEService(this.realmService, this.clientService, this.unrecognizedClientService);
        }
        catch (Exception e) {
            logger.info("Can't use SingleHomedBroadcastPXEService implementation");
            logger.info("Falling back to the SingleHomed implementation");
            return new SingleHomedPXEService(this.realmService, this.clientService, this.unrecognizedClientService);
        }
    }

    public void stopService() throws Exception {
        logger.info("Stopping...");
        if (null != this.acceptor) {
            this.acceptor.unbindAll();
        }
        this.acceptor = null;
        this.config = null;
        this.dhcpService = null;
        this.handler = null;
    }

    public boolean reloadRealms() throws DirectoryException {
        this.realmService.reload();
        return true;
    }
}

