/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.dhcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.messages.ArchType;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.messages.MessageType;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.dhcp.AbstractPXEService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EavesdroppingPXEService
extends AbstractPXEService {
    private static final Logger logger = LoggerFactory.getLogger(EavesdroppingPXEService.class);

    public EavesdroppingPXEService(RealmService realmService, ClientService clientService, UnrecognizedClientService unrecognizedClientService) throws DirectoryException {
        super(realmService, clientService, unrecognizedClientService);
    }

    @Override
    protected InetSocketAddress determineServerAddress(InetSocketAddress localAddress, DhcpMessage message) {
        try {
            InetAddress ifAddress = null;
            InetAddress ca = message.getAssignedClientAddress();
            byte[] assignedAddressBytes = ca.getAddress();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            block2: while (e.hasMoreElements()) {
                NetworkInterface nif = e.nextElement();
                for (InterfaceAddress ia : nif.getInterfaceAddresses()) {
                    if (!EavesdroppingPXEService.isInSubnet(assignedAddressBytes, ia.getAddress().getAddress(), ia.getNetworkPrefixLength())) continue;
                    ifAddress = ia.getAddress();
                    break block2;
                }
            }
            if (null != ifAddress) {
                return new InetSocketAddress(ifAddress, 67);
            }
        }
        catch (SocketException e) {
            logger.error("Error while determining network interface.", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DhcpMessage handleDISCOVER(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        AbstractPXEService.Conversation conversation;
        EavesdroppingPXEService.expireConversations();
        if (!this.assertCorrectPort(localAddress, 67, request)) {
            return null;
        }
        if (!ArchType.isPXEClient((DhcpMessage)request)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignoring non-PXE DISCOVER" + this.getLogDetail(localAddress, clientAddress, request));
            }
            return null;
        }
        AbstractPXEService.RequestID requestID = new AbstractPXEService.RequestID(request);
        if (logger.isInfoEnabled()) {
            logger.info("Got PXE DISCOVER" + this.getLogDetail(localAddress, clientAddress, request));
        }
        AbstractPXEService.Conversation conversation2 = conversation = new AbstractPXEService.Conversation(request);
        synchronized (conversation2) {
            conversations.put(requestID, conversation);
            String hwAddressString = request.getHardwareAddress().getNativeRepresentation();
            Client client = this.getClient(hwAddressString, clientAddress, request);
            if (client == null) {
                logger.info("Client not eligible for PXE proxy service");
                return null;
            }
            conversation.setClient(client);
            logger.info("Conversation started");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DhcpMessage handleOFFER(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage offer) throws DhcpException {
        if (!this.assertCorrectPort(localAddress, 68, offer)) {
            return null;
        }
        if (EavesdroppingPXEService.isZeroAddress(offer.getAssignedClientAddress())) {
            logger.debug("Ignoring PXE proxy offer " + this.getLogDetail(localAddress, clientAddress, offer));
            return null;
        }
        AbstractPXEService.RequestID id = new AbstractPXEService.RequestID(offer);
        AbstractPXEService.Conversation conversation = (AbstractPXEService.Conversation)conversations.get(id);
        if (null == conversation) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got OFFER for which there is no conversation" + this.getLogDetail(localAddress, clientAddress, offer));
            }
            return null;
        }
        AbstractPXEService.Conversation conversation2 = conversation;
        synchronized (conversation2) {
            if (conversation.isExpired()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Got OFFER for an expired conversation: " + conversation);
                }
                conversations.remove(id);
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Got OFFER within " + conversation);
            }
            if (conversation.getClient() == null) {
                this.trackUnrecognizedClient(conversation.getDiscover(), offer.getAssignedClientAddress().getHostAddress());
            } else {
                InetSocketAddress applicableServerAddress = this.determineServerAddress(localAddress, offer);
                if (applicableServerAddress != null) {
                    conversation.setApplicableServerAddress(applicableServerAddress);
                    DhcpMessage reply = this.initGeneralReply(applicableServerAddress, offer);
                    reply.setMessageType(MessageType.DHCPOFFER);
                    if (logger.isInfoEnabled()) {
                        logger.info("Sending PXE proxy offer " + offer);
                    }
                    return reply;
                }
                logger.error("InterfaceAddress not found for " + offer + ", " + conversation);
            }
            return null;
        }
    }

    @Override
    public void init(IoAcceptor acceptor, IoHandler handler, IoServiceConfig config) throws IOException {
        logger.warn("-------------------------------------------------------------");
        logger.warn("  Using EavesdroppingPXEService implementation.");
        logger.warn("  This type of PXE service will additionally bind on");
        logger.warn("  port 68 (bootpc) to analyse DHCP-server messages as well.");
        logger.warn("  (for more details, see log messages with level INFO)");
        logger.info("");
        InetSocketAddress dhcpCPort = new InetSocketAddress(67);
        logger.info("  Binding on " + dhcpCPort);
        acceptor.bind((SocketAddress)dhcpCPort, handler, config);
        InetSocketAddress dhcpSPort = new InetSocketAddress(68);
        logger.info("  Binding on " + dhcpSPort);
        acceptor.bind((SocketAddress)dhcpSPort, handler, config);
        InetSocketAddress pxePort = new InetSocketAddress(4011);
        logger.info("  Binding on " + pxePort);
        acceptor.bind((SocketAddress)pxePort, handler, config);
        logger.warn("-------------------------------------------------------------");
    }
}

