/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.PackageManagerFactory;
import org.openthinclient.service.common.Service;
import org.openthinclient.service.nfs.NFS;

public class PackageManagerService
implements Service<PackageManagerConfiguration> {
    private final NFS nfs;
    private final PackageManagerFactory packageManagerFactory;
    private volatile boolean running;
    private PackageManagerConfiguration configuration;
    private PackageManager packageManager;

    public PackageManagerService(NFS nfs, PackageManagerFactory packageManagerFactory) {
        if (nfs == null) {
            throw new IllegalArgumentException("nfs must not be null");
        }
        this.nfs = nfs;
        this.packageManagerFactory = packageManagerFactory;
    }

    public PackageManager getPackageManager() {
        if (!this.running) {
            throw new IllegalStateException("package manager service is not running");
        }
        return this.packageManager;
    }

    public PackageManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PackageManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    public Class<PackageManagerConfiguration> getConfigurationClass() {
        return PackageManagerConfiguration.class;
    }

    public void startService() throws Exception {
        this.running = true;
        this.packageManager = this.packageManagerFactory.createPackageManager(this.configuration);
    }

    public void stopService() throws Exception {
        this.running = false;
        this.packageManager.close();
    }
}

