/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.db;

import java.io.Serializable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.openthinclient.pkgmgr.I18N;

@Embeddable
@Access(value=AccessType.FIELD)
public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 3258135760426317876L;
    private static final Pattern SPECIFIER_PATTERN = Pattern.compile("^(?:(\\d+)\\:)?(\\d[A-Za-z0-9\\.\\+-~]*?)(?:-([A-Za-z0-9\\+\\.~]+))?$");
    private static final Pattern TOKENS = Pattern.compile("(\\d+|\\D+)");
    @Column(name="version_epoch")
    private int epoch = 0;
    @Column(name="version_upstream")
    private String upstreamVersion;
    @Column(name="version_revision")
    private String debianRevision;
    private transient int hashCode = -1;

    private static int compareNullableRevision(String version1, String version2) {
        if (version1 != null && version2 != null) {
            return Version.compareRevision(version1, version2);
        }
        if (version1 != null) {
            return 1;
        }
        if (version2 != null) {
            return -1;
        }
        return 0;
    }

    private static int compareRevision(String version1, String version2) {
        boolean version1StartsWithDigit = version1.length() > 0 && Character.isDigit(version1.charAt(0));
        boolean version2StartsWithDigit = version2.length() > 0 && Character.isDigit(version2.charAt(0));
        String version1Part = "";
        String version2Part = "";
        boolean doCompareNumeric = false;
        Iterator<String> version1Parts = Version.versionPartsIterator(version1);
        Iterator<String> version2Parts = Version.versionPartsIterator(version2);
        if (version1StartsWithDigit == version2StartsWithDigit) {
            doCompareNumeric = version1StartsWithDigit;
            version1Part = version1Parts.next();
            version2Part = version2Parts.next();
        } else if (version1StartsWithDigit) {
            version2Part = version2Parts.next();
        } else if (version2StartsWithDigit) {
            version1Part = version1Parts.next();
        }
        while (!version1Part.isEmpty() || !version2Part.isEmpty()) {
            int result = doCompareNumeric ? Version.compareNumeric(version1Part, version2Part) : Version.compareLexical(version1Part, version2Part);
            if (result != 0) {
                return result;
            }
            version1Part = version1Parts.next();
            version2Part = version2Parts.next();
            doCompareNumeric = !doCompareNumeric;
        }
        return 0;
    }

    private static Iterator<String> versionPartsIterator(String version) {
        Matcher matcher = TOKENS.matcher(version);
        return Stream.generate(() -> matcher.find() ? matcher.group(0) : "").iterator();
    }

    private static int compareNumeric(String part1, String part2) {
        int number1 = part1.isEmpty() ? 0 : Integer.parseInt(part1);
        int number2 = part2.isEmpty() ? 0 : Integer.parseInt(part2);
        return number1 - number2;
    }

    private static int compareLexical(String part1, String part2) {
        Iterator<Integer> iter1 = Version.codePointIterator(part1);
        Iterator<Integer> iter2 = Version.codePointIterator(part2);
        int length = Math.max(part1.length(), part2.length());
        for (int i = 0; i < length; ++i) {
            int result = iter1.next() - iter2.next();
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private static Iterator<Integer> codePointIterator(String source) {
        return Stream.concat(source.codePoints().boxed().map(i -> i == 126 ? -2 : i), Stream.generate(() -> -1)).iterator();
    }

    public static Version parse(String specifier) {
        String upstreamVersion;
        int epoch = 0;
        String debianRevision = null;
        try {
            Matcher m = SPECIFIER_PATTERN.matcher(specifier);
            if (!m.matches()) {
                throw new IllegalArgumentException(I18N.getMessage("Version.cantParseVersion") + ": " + specifier);
            }
            if (m.group(1) != null) {
                epoch = Integer.parseInt(m.group(1));
            }
            upstreamVersion = m.group(2);
            debianRevision = m.group(3);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(I18N.getMessage("Version.cantParseVersion") + ": ", e);
        }
        Version version = new Version();
        version.setEpoch(epoch);
        version.setUpstreamVersion(upstreamVersion);
        version.setDebianRevision(debianRevision);
        return version;
    }

    public boolean isPreview() {
        if (this.debianRevision == null || this.debianRevision.isEmpty()) {
            return this.upstreamVersion.contains("~");
        }
        return this.debianRevision.contains("~");
    }

    public int getEpoch() {
        return this.epoch;
    }

    public void setEpoch(int epoch) {
        this.epoch = epoch;
    }

    public String getUpstreamVersion() {
        return this.upstreamVersion;
    }

    public void setUpstreamVersion(String upstreamVersion) {
        this.upstreamVersion = upstreamVersion;
    }

    public String getDebianRevision() {
        return this.debianRevision;
    }

    public void setDebianRevision(String debianRevision) {
        this.debianRevision = debianRevision;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.epoch >= 0) {
            sb.append(this.epoch).append(":");
        }
        sb.append(this.upstreamVersion);
        if (null != this.debianRevision) {
            sb.append("-").append(this.debianRevision);
        }
        return sb.toString();
    }

    public String toStringWithoutEpoch() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.upstreamVersion);
        if (null != this.debianRevision) {
            sb.append("-").append(this.debianRevision);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        return o instanceof Version && this.compareTo((Version)o) == 0;
    }

    public int hashCode() {
        if (-1 == this.hashCode) {
            this.hashCode = 0x9BD74 ^ this.epoch ^ (this.upstreamVersion != null ? this.upstreamVersion.hashCode() : 0) ^ (this.debianRevision != null ? this.debianRevision.hashCode() : 0);
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(Version v) {
        int result = this.epoch - v.epoch;
        if (result != 0) {
            return result;
        }
        result = Version.compareNullableRevision(this.upstreamVersion, v.upstreamVersion);
        if (result != 0) {
            return result;
        }
        return Version.compareNullableRevision(this.debianRevision, v.debianRevision);
    }
}

