/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.op;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.FileUtils;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.pkgmgr.PackageChecksumVerificationFailedException;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.op.PackageOperation;
import org.openthinclient.pkgmgr.op.PackageOperationContext;
import org.openthinclient.progress.ProgressReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageOperationDownload
implements PackageOperation {
    private static final Logger LOG = LoggerFactory.getLogger(PackageOperationDownload.class);
    private final DownloadManager downloadManager;
    private final Package pkg;

    public PackageOperationDownload(Package pkg, DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
        this.pkg = pkg;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte aB : bytes) {
            int v = aB & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }

    @Override
    public Package getPackage() {
        return this.pkg;
    }

    protected MessageDigest getMD5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Broken JVM. No MD5 message digest available");
        }
    }

    @Override
    public void execute(PackageOperationContext context, ProgressReceiver progressReceiver) throws IOException {
        progressReceiver.progress("Downloading package '" + this.pkg.getName() + "' " + FileUtils.byteCountToDisplaySize((long)this.pkg.getSize()));
        URL sourceUrl = this.pkg.getSource().getUrl();
        if (!sourceUrl.toExternalForm().endsWith("/")) {
            sourceUrl = new URL(sourceUrl.toExternalForm() + "/");
        }
        URL packageURL = new URL(sourceUrl, this.pkg.getFilename());
        LOG.info("Downloading package {}", (Object)packageURL);
        context.getLocalPackageRepository().addPackage(this.pkg, targetPath -> this.downloadManager.download(packageURL, in -> {
            try (OutputStream out = Files.newOutputStream(targetPath, new OpenOption[0]);
                 DigestOutputStream digestOut = new DigestOutputStream(out, this.getMD5Digest());){
                ByteStreams.copy((InputStream)in, (OutputStream)digestOut);
                digestOut.flush();
                MessageDigest digest = digestOut.getMessageDigest();
                String md5sum = PackageOperationDownload.byteArrayToHexString(digest.digest());
                LOG.info("Download of {} complete. Computed MD5 {}", (Object)packageURL, (Object)md5sum);
                if (!Strings.isNullOrEmpty((String)this.pkg.getMD5sum()) && !this.pkg.getMD5sum().equalsIgnoreCase(md5sum)) {
                    LOG.error("Checksum validation failed. Exected {}, actual {}", (Object)this.pkg.getMD5sum().toLowerCase(), (Object)md5sum.toLowerCase());
                    throw new PackageChecksumVerificationFailedException("checksum validation failed", this.pkg, md5sum);
                }
            }
            return null;
        }, progressReceiver));
    }
}

