/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.io.FileSystemUtils;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.pkgmgr.I18N;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.SourcesList;
import org.openthinclient.pkgmgr.UpdateDatabase;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageInstalledContent;
import org.openthinclient.pkgmgr.db.PackageManagerDatabase;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.pkgmgr.db.Version;
import org.openthinclient.pkgmgr.exception.SourceIntegrityViolationException;
import org.openthinclient.pkgmgr.op.DefaultPackageManagerOperation;
import org.openthinclient.pkgmgr.op.PackageListUpdateReport;
import org.openthinclient.pkgmgr.op.PackageManagerOperation;
import org.openthinclient.pkgmgr.op.PackageManagerOperationReport;
import org.openthinclient.pkgmgr.op.PackageManagerOperationTask;
import org.openthinclient.pkgmgr.progress.PackageManagerExecutionEngine;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.util.dpkg.DefaultLocalPackageRepository;
import org.openthinclient.util.dpkg.LocalPackageRepository;
import org.openthinclient.util.dpkg.PackageManagerOperationResolverImpl;
import org.openthinclient.util.dpkg.PackageReference;
import org.openthinclient.util.dpkg.RemoveFromDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DPKGPackageManager
implements PackageManager {
    private static final Logger logger = LoggerFactory.getLogger(DPKGPackageManager.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final File installDir;
    private final File archivesDir;
    private final File testinstallDir;
    private final File oldInstallDir;
    private final File listsDir;
    private final PackageManagerConfiguration configuration;
    private final List<Package> pack = new LinkedList<Package>();
    private final List<Package> packForDelete = new LinkedList<Package>();
    private final PackageManagerDatabase packageManagerDatabase;
    private final PackageManagerExecutionEngine executionEngine;
    private final LocalPackageRepository localPackageRepository;
    private final List<PackagingConflict> conflicts = new ArrayList<PackagingConflict>();
    private PackageManagerTaskSummary taskSummary = new PackageManagerTaskSummary();
    private HashMap<File, File> fromToFileMap;
    private List<File> removeDirectoryList;
    private final DownloadManager downloadManager;

    public DPKGPackageManager(PackageManagerConfiguration configuration, PackageManagerDatabase packageManagerDatabase, PackageManagerExecutionEngine executionEngine, DownloadManager downloadManager) {
        this.configuration = configuration;
        this.packageManagerDatabase = packageManagerDatabase;
        this.executionEngine = executionEngine;
        this.localPackageRepository = new DefaultLocalPackageRepository(configuration.getArchivesDir().toPath());
        this.installDir = configuration.getInstallDir();
        this.archivesDir = configuration.getArchivesDir();
        this.testinstallDir = configuration.getTestinstallDir();
        this.oldInstallDir = configuration.getInstallOldDir();
        this.listsDir = configuration.getListsDir();
        this.downloadManager = downloadManager;
    }

    @Override
    public PackageManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void close() throws PackageManagerException {
    }

    private File relativeFile(File baseDirectory, File absoluteFile) {
        Path basePath = baseDirectory.getAbsoluteFile().toPath();
        Path absolutePath = absoluteFile.getAbsoluteFile().toPath();
        return basePath.relativize(absolutePath).toFile();
    }

    private boolean isRoot(File baseDirectory, File file) {
        return baseDirectory.equals(file);
    }

    private void addDependency(Map<PackageReference, List<Package>> unsatisfiedDependencies, PackageReference r, Package toBeInstalled) {
        if (!unsatisfiedDependencies.containsKey(r)) {
            unsatisfiedDependencies.put(r, new LinkedList());
        }
        unsatisfiedDependencies.get(r).add(toBeInstalled);
    }

    @Override
    public Collection<Package> getInstallablePackages() {
        return this.packageManagerDatabase.getPackageRepository().findInstallablePackages();
    }

    @Override
    public Collection<Package> getInstalledPackages() {
        return this.packageManagerDatabase.getPackageRepository().findByInstalledTrue();
    }

    @Override
    public Collection<Package> getInstallablePackagesWithoutInstalledOfSameVersion() {
        Collection<Package> installablePackages = this.getInstallablePackages();
        Collection<Package> installedPackages = this.getInstalledPackages();
        installablePackages.removeAll(installedPackages);
        return installablePackages;
    }

    @Override
    public Collection<Package> getUpdateablePackages(boolean applicationIsPreview) {
        ArrayList<Package> update = new ArrayList<Package>();
        Collection<Package> installedPackages = this.getInstalledPackages();
        Collection<Package> installablePackages = this.getInstallablePackages();
        for (Package installedPkg : installedPackages) {
            Version installedVersion = installedPkg.getVersion();
            for (Package installablePkg : installablePackages) {
                if (!installablePkg.getName().equals(installedPkg.getName())) continue;
                Version installableVersion = installablePkg.getVersion();
                if (!applicationIsPreview && installableVersion.isPreview() && !installedVersion.isPreview() || installableVersion.compareTo(installedVersion) <= 0) continue;
                update.add(installablePkg);
            }
        }
        return update;
    }

    private String getFormattedDate() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyy'_'MM'_'dd'_'HH'_'mm'_'ss");
        return sdf.format(new GregorianCalendar().getTime());
    }

    @Override
    public long getFreeDiskSpace() throws PackageManagerException {
        try {
            return FileSystemUtils.freeSpaceKb((String)this.installDir.getAbsolutePath());
        }
        catch (IOException io) {
            io.printStackTrace();
            this.addWarning(io.toString());
            logger.error("Failed to access free disk space information", (Throwable)io);
            return 0L;
        }
    }

    public ArrayList<String> getChangelogFile(Package p) throws IOException {
        throw new UnsupportedOperationException("This operation is not supported at the moment");
    }

    public HashMap<File, File> getFromToFileMap() {
        return this.fromToFileMap;
    }

    @Override
    public ListenableProgressFuture<PackageListUpdateReport> updateCacheDB() {
        return this.executionEngine.enqueue(new UpdateDatabase(this.configuration, this.getSourcesList(), this.packageManagerDatabase, this.downloadManager));
    }

    @Override
    public ListenableProgressFuture<PackageListUpdateReport> deleteSourcePackagesFromCacheDB(Source source) {
        return this.executionEngine.enqueue(new RemoveFromDatabase(this.configuration, source, this.packageManagerDatabase));
    }

    @Override
    public boolean addWarning(String warning) {
        this.taskSummary.addWarning(warning);
        return true;
    }

    public void setTaskSummary(PackageManagerTaskSummary taskSummary) {
        if (taskSummary == null) {
            throw new IllegalArgumentException("taskSummary must not be null");
        }
        this.taskSummary = taskSummary;
    }

    @Override
    public PackageManagerTaskSummary fetchTaskSummary() {
        PackageManagerTaskSummary result = this.taskSummary;
        this.taskSummary = new PackageManagerTaskSummary();
        return result;
    }

    @Override
    public SourcesList getSourcesList() {
        SourcesList sourcesList = new SourcesList();
        sourcesList.getSources().addAll(this.findAllSources());
        return sourcesList;
    }

    @Override
    public boolean isInstalled(Package pkg) {
        Package dbPackage = this.packageManagerDatabase.getBySourceAndNameAndVersion(pkg.getSource(), pkg.getName(), pkg.getVersion());
        return dbPackage != null && dbPackage.isInstalled();
    }

    @Override
    public boolean isInstallable(Package pkg) {
        Package dbPackage = this.packageManagerDatabase.getBySourceAndNameAndVersion(pkg.getSource(), pkg.getName(), pkg.getVersion());
        return dbPackage != null && !dbPackage.isInstalled();
    }

    @Override
    public LocalPackageRepository getLocalPackageRepository() {
        return this.localPackageRepository;
    }

    @Override
    public PackageManagerOperation createOperation() {
        return new DefaultPackageManagerOperation(new PackageManagerOperationResolverImpl(this::getInstalledPackages, this::getInstallablePackages));
    }

    @Override
    public ListenableProgressFuture<PackageManagerOperationReport> execute(PackageManagerOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("operation must not be null");
        }
        if (!(operation instanceof DefaultPackageManagerOperation)) {
            throw new IllegalArgumentException("The provided package manager operation is unsupported. (" + operation.getClass().getName() + ")");
        }
        return this.executionEngine.enqueue(new PackageManagerOperationTask(this.configuration, operation.getInstallPlan(), this.packageManagerDatabase, this.localPackageRepository, this.downloadManager));
    }

    @Override
    public void deleteSource(Source source) throws SourceIntegrityViolationException {
        List<Package> list = this.getInstalledPackages().stream().filter(p -> p.getSource().equals(source)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            throw new SourceIntegrityViolationException("Cannot delete source, because there are installed packages of this source", list);
        }
        this.packageManagerDatabase.getSourceRepository().delete(source);
    }

    @Override
    public Source saveSource(Source source) {
        return (Source)this.packageManagerDatabase.getSourceRepository().saveAndFlush(source);
    }

    @Override
    public Collection<Source> findAllSources() {
        return this.packageManagerDatabase.getSourceRepository().findAll().stream().filter(source -> !source.isDefaultSource()).collect(Collectors.toSet());
    }

    @Override
    public void saveSources(List<Source> sources) {
        this.packageManagerDatabase.getSourceRepository().saveAll(sources);
    }

    @Override
    public List<PackageInstalledContent> getInstalledPackageContents(Package pkg) {
        return this.packageManagerDatabase.getInstalledContentRepository().findByPkgOrderBySequenceDesc(pkg);
    }

    public static class PackagingConflict {
        private final Type type;
        private final Package pkg;
        private Package conflicting;
        private List<Package> pkgs;
        private PackageReference ref;
        private File file;

        public PackagingConflict(Type type, Package pkg) {
            this.type = type;
            this.pkg = pkg;
        }

        public PackagingConflict(Type type, Package pkg, Package conflicting) {
            this(type, pkg);
            this.conflicting = conflicting;
        }

        public PackagingConflict(Type type, PackageReference ref, List<Package> pkgs) {
            this(type, null);
            this.ref = ref;
            this.pkgs = pkgs;
        }

        public PackagingConflict(Type type, Package pkg, Package conflicting, File f) {
            this(type, pkg, conflicting);
            this.file = f;
        }

        public Package getConflictingPackage() {
            return this.pkg;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            switch (this.type) {
                case ALREADY_INSTALLED: {
                    sb.append(this.pkg).append(" ");
                    break;
                }
                case CONFLICT_EXISTING: {
                    sb.append(this.pkg.forConflictsToString()).append(" ").append(" ").append(this.conflicting.forConflictsToString());
                    break;
                }
                case CONFLICT_NEW: {
                    sb.append(this.pkg.forConflictsToString()).append(" ").append(" ").append(this.conflicting.forConflictsToString());
                    break;
                }
                case UNSATISFIED: {
                    sb.append(" ").append(this.ref).append(" ").append(" ");
                    for (Package pkg : this.pkgs) {
                        sb.append(pkg.getName()).append(" ");
                    }
                    break;
                }
                case FILE_CONFLICT: {
                    sb.append(I18N.getMessage("packageManager.toString.ALREADY_INSTALLED")).append(" ").append(this.file).append(" ").append(I18N.getMessage("packageManager.toString.ALREADY_INSTALLED")).append(" ").append(this.pkg).append(" ").append(I18N.getMessage("packageManager.toString.ALREADY_INSTALLED")).append(" ").append(this.conflicting);
                }
            }
            return sb.toString();
        }

        public static enum Type {
            ALREADY_INSTALLED,
            CONFLICT_EXISTING,
            CONFLICT_NEW,
            UNSATISFIED,
            FILE_CONFLICT,
            CONFLICT_WITHIN;

        }
    }

    public static enum DeleteMode {
        OLDINSTALLDIR,
        INSTALLDIR;

    }
}

