/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.datatype;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StringTools {
    public static final int APPEND = 1;
    public static final int PREPEND = -1;

    public static String replaceAll(String source, String pattern, String replacement) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = source.toCharArray();
        int res = 0;
        int slen = source.length();
        for (int n = 0; n < source.length(); ++n) {
            res = source.indexOf(pattern, n);
            if (res < n) {
                buffer.append(chars, n, slen - n);
                break;
            }
            buffer.append(chars, n, res - n);
            buffer.append(replacement);
            n = res;
        }
        return buffer.toString();
    }

    public static StringBuffer fillString(String givenString, int expectedLength, int type, char fillCharacter) {
        String workingString = givenString;
        if (givenString == null) {
            workingString = "";
        }
        if (givenString.length() > expectedLength) {
            workingString = givenString.trim();
        }
        if (workingString.length() > expectedLength) {
            return new StringBuffer(workingString.substring(0, expectedLength));
        }
        StringBuffer outputString = new StringBuffer(expectedLength);
        if (type == 1) {
            outputString.append(workingString);
        }
        for (int i = 0; i < expectedLength - workingString.length(); ++i) {
            outputString.append(fillCharacter);
        }
        if (type == -1) {
            outputString.append(workingString);
        }
        return outputString;
    }

    public static StringBuffer fillStringNoChop(String givenString, int maxFillLength, int type, char fillCharacter) {
        String workingString = givenString;
        if (givenString == null) {
            workingString = "";
        }
        StringBuffer outputString = new StringBuffer(maxFillLength);
        if (type == 1) {
            outputString.append(workingString);
        }
        for (int i = 0; i < maxFillLength - workingString.length(); ++i) {
            outputString.append(fillCharacter);
        }
        if (type == -1) {
            outputString.append(workingString);
        }
        return outputString;
    }

    public static String toHex(byte[] data) {
        return StringTools.toHex(data, 0, data.length);
    }

    public static String toHex(byte[] data, int offset, int len) {
        if (data == null) {
            return "'null'";
        }
        if (data.length < offset + len) {
            return "'incorrect length'";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = offset; i < offset + len; ++i) {
            sb.append(Integer.toHexString(data[i]));
            if (i >= offset + len - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String stringToTrim, char charToRemove) {
        int start;
        if (stringToTrim == null) {
            return null;
        }
        for (start = 0; start < stringToTrim.length() && stringToTrim.toCharArray()[start] == charToRemove; ++start) {
        }
        return start > 0 ? stringToTrim.substring(start, stringToTrim.length()) : stringToTrim;
    }

    public static String trimTrailingCharacter(String stringToTrim, char charToRemove) {
        int length;
        if (stringToTrim == null) {
            return null;
        }
        for (length = stringToTrim.length(); length > 0 && stringToTrim.toCharArray()[length - 1] == charToRemove; --length) {
        }
        return length < stringToTrim.length() ? stringToTrim.substring(0, length) : stringToTrim;
    }

    public static String trimCharacter(String stringToTrim, char charToRemove) {
        return StringTools.trimTrailingCharacter(StringTools.trimLeadingCharacter(stringToTrim, charToRemove), charToRemove);
    }

    private StringTools() {
    }

    public static int indexOf(byte[] buffer, String matchString, int fromIndex) {
        int matchIndex = -1;
        boolean found = false;
        int i = fromIndex;
        while (i < buffer.length && !found) {
            matchIndex = -1;
            found = true;
            for (int j = 0; j < matchString.length(); ++j) {
                if (buffer[i + j] == matchString.charAt(j)) continue;
                found = false;
                break;
            }
            matchIndex = i++;
        }
        return found ? matchIndex : -1;
    }

    public static int lastIndexOf(byte[] buffer, String matchString, int toIndex) {
        int matchIndex = -1;
        boolean found = false;
        int i = toIndex;
        while (i >= 0 && !found) {
            matchIndex = -1;
            found = true;
            for (int j = 0; j < matchString.length(); ++j) {
                if (buffer[i + j] == matchString.charAt(j)) continue;
                found = false;
                break;
            }
            matchIndex = i--;
        }
        return found ? matchIndex : -1;
    }

    public static String create(InputStream is) throws IOException {
        ByteArrayOutputStream baos = StringTools.isToBAOS(is);
        return baos.toString();
    }

    private static ByteArrayOutputStream isToBAOS(InputStream is) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = is.read(buffer)) > 0) {
            baos.write(buffer, 0, read);
        }
        is.close();
        return baos;
    }

    public static String create(InputStream is, String encoding) throws IOException {
        ByteArrayOutputStream baos = StringTools.isToBAOS(is);
        return baos.toString(encoding);
    }
}

