/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.ldif.export;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Name;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.directory.server.tools.ToolCommandListener;
import org.apache.directory.server.tools.commands.importcmd.ImportCommandExecutor;
import org.apache.directory.server.tools.util.ListenerParameter;
import org.apache.directory.server.tools.util.Parameter;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifImporterService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final String BASEDN_REPLACE = "#%BASEDN%#";
    private LDAPConnectionDescriptor lcd;

    public LdifImporterService(LDAPConnectionDescriptor ldapConnectionDescriptor) {
        this.lcd = ldapConnectionDescriptor;
    }

    private void importAction(File importFile, final Consumer<State> result) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("import following temporary file: " + importFile);
        }
        NameCallback nc = new NameCallback("Bind DN");
        PasswordCallback pc = new PasswordCallback("Password", false);
        this.lcd.getCallbackHandler().handle(new Callback[]{nc, pc});
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        ImportCommandExecutor importCommandExecutor = new ImportCommandExecutor();
        params.add(new Parameter("host", (Object)this.lcd.getHostname()));
        params.add(new Parameter("port", (Object)new Integer(this.lcd.getPortNumber())));
        switch (this.lcd.getAuthenticationMethod()) {
            case SIMPLE: {
                params.add(new Parameter("auth", (Object)"simple"));
                params.add(new Parameter("user", (Object)nc.getName()));
                params.add(new Parameter("password", (Object)new String(pc.getPassword())));
            }
        }
        params.add(new Parameter("file", (Object)importFile));
        params.add(new Parameter("ignore-errors", (Object)new Boolean(true)));
        params.add(new Parameter("debug", (Object)new Boolean(false)));
        params.add(new Parameter("verbose", (Object)new Boolean(false)));
        params.add(new Parameter("quiet", (Object)new Boolean(false)));
        ListenerParameter[] listeners = new ListenerParameter[]{new ListenerParameter("exceptionListener", new ToolCommandListener(){

            public void notify(Serializable o) {
                LdifImporterService.this.logger.error("Exception occurred while importing from ldif-file.", (Object)o);
                result.accept(State.EXCEPTION);
            }
        }), new ListenerParameter("ouputListener", new ToolCommandListener(){

            public void notify(Serializable o) {
                result.accept(State.SUCCESS);
            }
        }), new ListenerParameter("errorListener", new ToolCommandListener(){

            public void notify(Serializable o) {
                LdifImporterService.this.logger.info("Error occurred while importing from ldif-file: {}", (Object)o.toString());
            }
        })};
        importCommandExecutor.execute(params.toArray(new Parameter[params.size()]), listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTempFile(File importFile, Consumer<State> result) throws Exception {
        String strLine;
        FileInputStream fstream = new FileInputStream(importFile);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuffer content = new StringBuffer();
        String baseDn = this.lcd.getBaseDN();
        LdapContext ctx = this.lcd.createDirectoryFacade().createDirContext();
        Name targetName = ctx.getNameParser("").parse("");
        if (LdifImporterService.isRootImportLdifFile(importFile)) {
            Util.deleteRecursively((DirContext)ctx, (Name)targetName, (String)"^cn=administrator[s]?$");
        }
        Pattern toReplace = Pattern.compile(".*#%BASEDN%#$");
        while ((strLine = br.readLine()) != null) {
            Matcher m = toReplace.matcher(strLine);
            if (m.matches()) {
                int pos = strLine.lastIndexOf(BASEDN_REPLACE);
                content.append(strLine.substring(0, pos) + baseDn).append(System.getProperty("line.separator"));
                continue;
            }
            content.append(strLine).append(System.getProperty("line.separator"));
        }
        in.close();
        File tempFile = File.createTempFile("openthinclient-import-", ".ldif");
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(tempFile.getAbsolutePath()));
            os.write(content.toString().getBytes());
        }
        finally {
            if (null != os) {
                os.flush();
                os.close();
            }
        }
        this.importAction(tempFile, result);
        tempFile.delete();
    }

    private static boolean isRootImportLdifFile(File importFile) throws IOException {
        FileInputStream fstream = new FileInputStream(importFile);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        br.readLine();
        String s = br.readLine();
        return s != null && s.matches("^dn:[ ]+#%BASEDN%#$");
    }

    public static enum State {
        EXCEPTION,
        ERROR,
        SUCCESS;

    }
}

