/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.DefaultDirectoryServiceConfiguration;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.DirectoryServiceListener;
import org.apache.directory.server.core.authz.AuthorizationService;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.jndi.AbstractContextFactory;
import org.apache.directory.server.core.jndi.DeadContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.DefaultPartitionNexus;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.GlobalRegistries;
import org.apache.directory.server.core.schema.bootstrap.BootstrapRegistries;
import org.apache.directory.server.core.schema.bootstrap.BootstrapSchemaLoader;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationNotSupportedException;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultDirectoryService
extends DirectoryService {
    private static final Logger log = LoggerFactory.getLogger((Class)DefaultDirectoryService.class);
    private static final String BINARY_KEY = "java.naming.ldap.attributes.binary";
    private final String instanceId;
    private final DirectoryServiceConfiguration configuration = new DefaultDirectoryServiceConfiguration(this);
    private DirectoryServiceListener serviceListener;
    private Hashtable environment;
    private StartupConfiguration startupConfiguration;
    private GlobalRegistries globalRegistries;
    private DefaultPartitionNexus partitionNexus;
    private boolean firstStart;
    private InterceptorChain interceptorChain;
    private boolean started = false;

    public DefaultDirectoryService(String instanceId) {
        if (instanceId == null) {
            throw new NullPointerException("instanceId");
        }
        this.instanceId = instanceId;
    }

    public Context getJndiContext(String rootDN) throws NamingException {
        return this.getJndiContext(null, null, null, "none", rootDN);
    }

    public synchronized Context getJndiContext(LdapDN principalDn, String principal, byte[] credential, String authentication, String rootDN) throws NamingException {
        this.checkSecuritySettings(principal, credential, authentication);
        if (!this.started) {
            return new DeadContext();
        }
        Hashtable environment = this.getEnvironment();
        environment.remove("java.naming.security.principal");
        environment.remove("java.naming.security.credentials");
        environment.remove("java.naming.security.authentication");
        if (principal != null) {
            environment.put("java.naming.security.principal", principal);
        }
        if (credential != null) {
            environment.put("java.naming.security.credentials", credential);
        }
        if (authentication != null) {
            environment.put("java.naming.security.authentication", authentication);
        }
        if (rootDN == null) {
            rootDN = "";
        }
        environment.put("java.naming.provider.url", rootDN);
        if (principalDn != null) {
            environment.put("parsed.bind.dn", principalDn);
        }
        return new ServerLdapContext(this, environment);
    }

    public synchronized void startup(DirectoryServiceListener listener, Hashtable env) throws NamingException {
        if (this.started) {
            return;
        }
        Hashtable envCopy = (Hashtable)env.clone();
        StartupConfiguration cfg = (StartupConfiguration)Configuration.toConfiguration(env);
        if (cfg.isShutdownHookEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    try {
                        DefaultDirectoryService.this.shutdown();
                    }
                    catch (NamingException e) {
                        log.warn("Failed to shut down the directory service: " + DefaultDirectoryService.this.instanceId, (Throwable)e);
                    }
                }
            }, "ApacheDS Shutdown Hook (" + this.instanceId + ')'));
            log.info("ApacheDS shutdown hook has been registered with the runtime.");
        } else if (log.isWarnEnabled()) {
            log.warn("ApacheDS shutdown hook has NOT been registered with the runtime.  This default setting for standalone operation has been overriden.");
        }
        envCopy.put("java.naming.provider.url", "");
        try {
            cfg.validate();
        }
        catch (ConfigurationException e) {
            LdapConfigurationException ne = new LdapConfigurationException("Invalid configuration.");
            ne.initCause(e);
            throw ne;
        }
        this.environment = envCopy;
        this.startupConfiguration = cfg;
        listener.beforeStartup(this);
        this.initialize();
        this.firstStart = this.createBootstrapEntries();
        this.showSecurityWarnings();
        this.serviceListener = listener;
        this.started = true;
        if (!this.startupConfiguration.getTestEntries().isEmpty()) {
            this.createTestEntries(env);
        }
        listener.afterStartup(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sync() throws NamingException {
        if (!this.started) {
            return;
        }
        this.serviceListener.beforeSync(this);
        try {
            this.partitionNexus.sync();
        }
        finally {
            this.serviceListener.afterSync(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() throws NamingException {
        if (!this.started) {
            return;
        }
        this.serviceListener.beforeShutdown(this);
        try {
            this.partitionNexus.sync();
            this.partitionNexus.destroy();
            this.interceptorChain.destroy();
            this.started = false;
        }
        finally {
            this.serviceListener.afterShutdown(this);
            this.environment = null;
            this.interceptorChain = null;
            this.startupConfiguration = null;
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public DirectoryServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public Hashtable getEnvironment() {
        return (Hashtable)this.environment.clone();
    }

    public DirectoryServiceListener getServiceListener() {
        return this.serviceListener;
    }

    public StartupConfiguration getStartupConfiguration() {
        return this.startupConfiguration;
    }

    public GlobalRegistries getGlobalRegistries() {
        return this.globalRegistries;
    }

    public PartitionNexus getPartitionNexus() {
        return this.partitionNexus;
    }

    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    public boolean isFirstStart() {
        return this.firstStart;
    }

    public boolean isStarted() {
        return this.started;
    }

    private void checkSecuritySettings(String principal, byte[] credential, String authentication) throws NamingException {
        if (authentication == null) {
            authentication = "";
        }
        if ("simple".equalsIgnoreCase(authentication)) {
            if (credential == null) {
                throw new LdapConfigurationException("missing required java.naming.security.credentials property for simple authentication");
            }
            if (principal == null) {
                throw new LdapConfigurationException("missing required java.naming.security.principal property for simple authentication");
            }
        } else if ("none".equalsIgnoreCase(authentication)) {
            if (credential != null) {
                throw new LdapConfigurationException("ambiguous bind settings encountered where bind is anonymous yet java.naming.security.credentials property is set");
            }
            if (principal != null) {
                throw new LdapConfigurationException("ambiguous bind settings encountered where bind is anonymous yet java.naming.security.principal property is set");
            }
            if (!this.startupConfiguration.isAllowAnonymousAccess()) {
                throw new LdapNoPermissionException("Anonymous access disabled.");
            }
        } else {
            throw new LdapAuthenticationNotSupportedException("Unknown authentication type: '" + authentication + "'", ResultCodeEnum.AUTHMETHODNOTSUPPORTED);
        }
    }

    private boolean createBootstrapEntries() throws NamingException {
        boolean firstStart = false;
        if (!this.partitionNexus.hasEntry(PartitionNexus.getAdminName())) {
            firstStart = true;
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("person");
            objectClass.add("organizationalPerson");
            objectClass.add("inetOrgPerson");
            attributes.put((Attribute)objectClass);
            attributes.put("uid", "admin");
            attributes.put("userPassword", "secret");
            attributes.put("displayName", "Directory Superuser");
            attributes.put("cn", "system administrator");
            attributes.put("sn", "administrator");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            attributes.put("displayName", "Directory Superuser");
            this.partitionNexus.add(PartitionNexus.getAdminName(), (Attributes)attributes);
        }
        Map oidsMap = this.configuration.getGlobalRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        LdapDN userDn = new LdapDN("ou=users,ou=system");
        userDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(userDn)) {
            firstStart = true;
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "users");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(userDn, (Attributes)attributes);
        }
        LdapDN groupDn = new LdapDN("ou=groups,ou=system");
        groupDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(groupDn)) {
            firstStart = true;
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "groups");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(groupDn, (Attributes)attributes);
        }
        String upName = "cn=Administrators,ou=groups,ou=system";
        LdapDN normName = new LdapDN("cn=administrators,ou=groups,ou=system");
        normName.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(normName)) {
            firstStart = true;
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("groupOfUniqueNames");
            attributes.put((Attribute)objectClass);
            attributes.put("cn", "Administrators");
            attributes.put("uniqueMember", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(normName, (Attributes)attributes);
            Interceptor authzInterceptor = this.interceptorChain.get("authorizationService");
            if (authzInterceptor == null) {
                log.error("The Authorization service is null : this is not allowed");
                throw new NamingException("The Authorization service is null");
            }
            if (!(authzInterceptor instanceof AuthorizationService)) {
                log.error("The Authorization service is not set correctly : '{}' is an incorect interceptor", (Object)authzInterceptor.getClass().getName());
                throw new NamingException("The Authorization service is incorrectly set");
            }
            AuthorizationService authzSrvc = (AuthorizationService)authzInterceptor;
            authzSrvc.cacheNewGroup(upName, normName, (Attributes)attributes);
        }
        LdapDN configurationDn = new LdapDN("ou=configuration,ou=system");
        configurationDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(configurationDn)) {
            firstStart = true;
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "configuration");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(configurationDn, (Attributes)attributes);
        }
        LdapDN partitionsDn = new LdapDN("ou=partitions,ou=configuration,ou=system");
        partitionsDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(partitionsDn)) {
            firstStart = true;
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "partitions");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(partitionsDn, (Attributes)attributes);
        }
        LdapDN servicesDn = new LdapDN("ou=services,ou=configuration,ou=system");
        servicesDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(servicesDn)) {
            firstStart = true;
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "services");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(servicesDn, (Attributes)attributes);
        }
        LdapDN interceptorsDn = new LdapDN("ou=interceptors,ou=configuration,ou=system");
        interceptorsDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(interceptorsDn)) {
            firstStart = true;
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("ou", "interceptors");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(interceptorsDn, (Attributes)attributes);
        }
        LdapDN sysPrefRootDn = new LdapDN("prefNodeName=sysPrefRoot,ou=system");
        sysPrefRootDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(sysPrefRootDn)) {
            firstStart = true;
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            attributes.put((Attribute)objectClass);
            attributes.put("objectClass", "extensibleObject");
            attributes.put("prefNodeName", "sysPrefRoot");
            attributes.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            this.partitionNexus.add(sysPrefRootDn, (Attributes)attributes);
        }
        return firstStart;
    }

    private void showSecurityWarnings() throws NamingException {
        boolean needToChangeAdminPassword = false;
        LdapDN adminDn = new LdapDN("uid=admin,ou=system");
        adminDn.normalize(this.configuration.getGlobalRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        Attributes adminEntry = this.partitionNexus.lookup(adminDn);
        Object userPassword = adminEntry.get("userPassword").get();
        if (userPassword instanceof byte[]) {
            needToChangeAdminPassword = "secret".equals(new String((byte[])userPassword));
        } else if (userPassword.toString().equals("secret")) {
            needToChangeAdminPassword = "secret".equals(userPassword.toString());
        }
        if (needToChangeAdminPassword) {
            log.warn("You didn't change the admin password of directory service instance '" + this.instanceId + "'.  " + "Please update the admin password as soon as possible " + "to prevent a possible security breach.");
        }
    }

    private void createTestEntries(Hashtable env) throws NamingException {
        String principal = AbstractContextFactory.getPrincipal(env);
        byte[] credential = AbstractContextFactory.getCredential(env);
        String authentication = AbstractContextFactory.getAuthentication(env);
        LdapDN principalDn = (LdapDN)env.get("parsed.bind.dn");
        ServerLdapContext ctx = (ServerLdapContext)this.getJndiContext(principalDn, principal, credential, authentication, "");
        Iterator i = this.startupConfiguration.getTestEntries().iterator();
        while (i.hasNext()) {
            try {
                Entry entry = (Entry)((Entry)i.next()).clone();
                Attributes attributes = entry.getAttributes();
                String dn = entry.getDn();
                try {
                    ctx.createSubcontext(dn, attributes);
                }
                catch (Exception e) {
                    log.warn(dn + " test entry already exists.", (Throwable)e);
                }
            }
            catch (CloneNotSupportedException cnse) {
                log.warn("Cannot clone the entry ", (Throwable)cnse);
            }
        }
    }

    private void initialize() throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug("---> Initializing the DefaultDirectoryService ");
        }
        BootstrapRegistries bootstrapRegistries = new BootstrapRegistries();
        BootstrapSchemaLoader loader = new BootstrapSchemaLoader();
        loader.load(this.startupConfiguration.getBootstrapSchemas(), bootstrapRegistries);
        List errors = bootstrapRegistries.checkRefInteg();
        if (!errors.isEmpty()) {
            NamingException e = new NamingException();
            e.setRootCause((Throwable)errors.get(0));
            throw e;
        }
        this.globalRegistries = new GlobalRegistries(bootstrapRegistries);
        HashSet<String> binaries = new HashSet<String>();
        if (this.environment.containsKey(BINARY_KEY)) {
            String binaryIds;
            if (log.isInfoEnabled()) {
                log.info("Startup environment contains java.naming.ldap.attributes.binary");
            }
            if ((binaryIds = (String)this.environment.get(BINARY_KEY)) == null) {
                if (log.isWarnEnabled()) {
                    log.warn("java.naming.ldap.attributes.binary in startup environment contains null value.  Using only schema info to set binary attributeTypes.");
                }
            } else {
                if (!StringTools.isEmpty((String)binaryIds)) {
                    String[] binaryArray = binaryIds.split(" ");
                    for (int i = 0; i < binaryArray.length; ++i) {
                        binaries.add(StringTools.lowerCase((String)StringTools.trim((String)binaryArray[i])));
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info("Setting binaries to union of schema defined binaries and those provided in java.naming.ldap.attributes.binary");
                }
            }
        }
        AttributeTypeRegistry registry = this.globalRegistries.getAttributeTypeRegistry();
        Iterator list = registry.list();
        while (list.hasNext()) {
            AttributeType type = (AttributeType)list.next();
            if (type.getSyntax().isHumanReadible()) continue;
            binaries.add(type.getOid());
            String[] names = type.getNames();
            for (int ii = 0; ii < names.length; ++ii) {
                binaries.add(StringTools.lowerCase((String)StringTools.trim((String)names[ii])));
            }
        }
        this.environment.put(BINARY_KEY, binaries);
        if (log.isDebugEnabled()) {
            log.debug("binary ids used: " + binaries);
        }
        this.partitionNexus = new DefaultPartitionNexus((Attributes)new LockableAttributesImpl());
        this.partitionNexus.init(this.configuration, null);
        this.interceptorChain = new InterceptorChain();
        this.interceptorChain.init(this.configuration);
        if (log.isDebugEnabled()) {
            log.debug("<--- DefaultDirectoryService initialized");
        }
    }
}

