/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.configuration;

import java.util.HashSet;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.core.configuration.ConfigurationUtil;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.schema.MatchingRuleRegistry;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class PartitionConfiguration {
    public static final String SYSTEM_PARTITION_NAME = "system";
    public static final int DEFAULT_CACHE_SIZE = 10000;
    private String name;
    private int cacheSize = -1;
    private String suffix;
    private Set indexedAttributes;
    private Attributes contextEntry = new LockableAttributesImpl(true);
    private Partition contextPartition = new JdbmPartition();

    protected PartitionConfiguration() {
        this.setIndexedAttributes(new HashSet());
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name = name.trim();
    }

    public Set getIndexedAttributes() {
        return ConfigurationUtil.getClonedSet(this.indexedAttributes);
    }

    protected void setIndexedAttributes(Set indexedAttributes) {
        this.indexedAttributes = indexedAttributes;
    }

    public Partition getContextPartition() {
        return this.contextPartition;
    }

    protected void setContextPartition(Partition partition) {
        if (partition == null) {
            throw new NullPointerException("partition");
        }
        this.contextPartition = partition;
    }

    public Attributes getContextEntry() {
        return (Attributes)this.contextEntry.clone();
    }

    protected void setContextEntry(Attributes rootEntry) {
        this.contextEntry = (Attributes)rootEntry.clone();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Name getNormalizedSuffix(MatchingRuleRegistry matchingRuleRegistry) throws NamingException {
        return this.getNormalizedSuffix(matchingRuleRegistry.lookup("distinguishedNameMatch").getNormalizer());
    }

    public Name getNormalizedSuffix(Normalizer normalizer) throws NamingException {
        return new LdapDN(normalizer.normalize((Object)this.suffix).toString());
    }

    protected void setSuffix(String suffix) throws NamingException {
        suffix = suffix.trim();
        try {
            new LdapDN(suffix);
        }
        catch (NamingException e) {
            throw new LdapConfigurationException("Failed to parse the suffix: " + suffix, (Throwable)e);
        }
        this.suffix = suffix;
    }

    public void validate() {
        if (this.getName() == null || this.getName().length() == 0) {
            throw new ConfigurationException("Name is not specified.");
        }
        if (this.getSuffix() == null) {
            throw new ConfigurationException("Suffix is not specified.");
        }
    }

    protected void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }
}

