/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.normalization.ExpandingVisitor;
import org.apache.directory.server.core.normalization.NormalizingVisitor;
import org.apache.directory.server.core.normalization.UndefinedFilterAttributeException;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.EmptyEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizationService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger((Class)NormalizationService.class);
    private NormalizingVisitor normVisitor;
    private ExpandingVisitor expVisitor;
    private AttributeTypeRegistry attributeRegistry;

    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        OidRegistry oidRegistry = factoryCfg.getGlobalRegistries().getOidRegistry();
        this.attributeRegistry = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.attributeRegistry, oidRegistry);
        this.normVisitor = new NormalizingVisitor(ncn, oidRegistry);
        this.expVisitor = new ExpandingVisitor(this.attributeRegistry);
    }

    public void destroy() {
    }

    public void add(NextInterceptor nextInterceptor, LdapDN name, Attributes attrs) throws NamingException {
        LdapDN normalized = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        nextInterceptor.add(normalized, attrs);
    }

    public void delete(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        LdapDN normalized = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        nextInterceptor.delete(normalized);
    }

    public void modify(NextInterceptor nextInterceptor, LdapDN name, int modOp, Attributes attrs) throws NamingException {
        LdapDN normalized = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        nextInterceptor.modify(normalized, modOp, attrs);
    }

    public void modify(NextInterceptor nextInterceptor, LdapDN name, ModificationItemImpl[] items) throws NamingException {
        LdapDN normalized = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        nextInterceptor.modify(normalized, items);
    }

    public void modifyRn(NextInterceptor nextInterceptor, LdapDN name, String newRn, boolean deleteOldRn) throws NamingException {
        LdapDN normalized = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        nextInterceptor.modifyRn(normalized, newRn, deleteOldRn);
    }

    public void move(NextInterceptor nextInterceptor, LdapDN name, LdapDN newParentName) throws NamingException {
        LdapDN normalized = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        newParentName.normalize(this.attributeRegistry.getNormalizerMapping());
        nextInterceptor.move(normalized, newParentName);
    }

    public void move(NextInterceptor nextInterceptor, LdapDN name, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
        LdapDN normalized = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        newParentName.normalize(this.attributeRegistry.getNormalizerMapping());
        nextInterceptor.move(normalized, newParentName, newRn, deleteOldRn);
    }

    public NamingEnumeration search(NextInterceptor nextInterceptor, LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        BranchNode bnode;
        LeafNode ln;
        base.normalize(this.attributeRegistry.getNormalizerMapping());
        if (filter.isLeaf() && !this.attributeRegistry.hasAttributeType((ln = (LeafNode)filter).getAttribute())) {
            StringBuffer buf = new StringBuffer();
            buf.append("undefined filter based on undefined attributeType '");
            buf.append(ln.getAttribute());
            buf.append("' not evaluted at all.  Returning empty enumeration.");
            log.warn(buf.toString());
            return new EmptyEnumeration();
        }
        boolean isFailure = true;
        while (isFailure && filter != null) {
            try {
                LeafNode ln2;
                if (filter.isLeaf() && !this.attributeRegistry.hasAttributeType((ln2 = (LeafNode)filter).getAttribute())) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("undefined filter based on undefined attributeType '");
                    buf.append(ln2.getAttribute());
                    buf.append("' not evaluted at all.  Returning empty enumeration.");
                    log.warn(buf.toString());
                    return new EmptyEnumeration();
                }
                filter.accept((FilterVisitor)this.normVisitor);
                isFailure = false;
            }
            catch (UndefinedFilterAttributeException e) {
                isFailure = true;
                if (log.isWarnEnabled()) {
                    log.warn("An undefined attribute was found within the supplied search filter.  The node associated with the filter has been removed.", e.getCause());
                }
                if ((bnode = (BranchNode)filter).isNegation()) {
                    return new EmptyEnumeration();
                }
                bnode.getChildren().remove(e.getUndefinedFilterNode());
                if (bnode.getOperator() == 10) {
                    return new EmptyEnumeration();
                }
                if (bnode.getChildren().size() >= 2) continue;
                filter = bnode.getChild();
            }
        }
        if (!filter.isLeaf()) {
            BranchNode child = (BranchNode)filter;
            if (child.getChildren().size() == 0 || child.get((Object)"undefined") == Boolean.TRUE) {
                log.warn("Undefined branchnode filter without child nodes not evaluted at all.  Returning empty enumeration.");
                return new EmptyEnumeration();
            }
            if (child.getChildren().size() == 1 && child.getOperator() != 11) {
                filter = child.getChild();
            }
        }
        if (!filter.isLeaf()) {
            this.expVisitor.visit(filter);
        } else {
            LeafNode leaf = (LeafNode)filter;
            if (this.attributeRegistry.hasDescendants(leaf.getAttribute())) {
                bnode = new BranchNode(9);
                bnode.getChildren().add(filter);
                filter = bnode;
                Iterator descendants = this.attributeRegistry.descendants(leaf.getAttribute());
                while (descendants.hasNext()) {
                    PresenceNode newLeaf = null;
                    AttributeType descendant = (AttributeType)descendants.next();
                    switch (leaf.getAssertionType()) {
                        case 6: {
                            ExtensibleNode extensibleNode = (ExtensibleNode)leaf;
                            newLeaf = new ExtensibleNode(descendant.getOid(), extensibleNode.getValue(), extensibleNode.getMatchingRuleId(), extensibleNode.dnAttributes());
                            break;
                        }
                        case 1: {
                            newLeaf = new PresenceNode(descendant.getOid());
                            break;
                        }
                        case 2: {
                            SubstringNode substringNode = (SubstringNode)leaf;
                            newLeaf = new SubstringNode(descendant.getOid(), substringNode.getInitial(), substringNode.getFinal());
                            break;
                        }
                        case 0: 
                        case 3: 
                        case 4: 
                        case 5: {
                            SimpleNode simpleNode = (SimpleNode)leaf;
                            if (simpleNode.getValue() instanceof String) {
                                newLeaf = new SimpleNode(descendant.getOid(), (String)simpleNode.getValue(), simpleNode.getAssertionType());
                                break;
                            }
                            if (simpleNode.getValue() instanceof byte[]) {
                                newLeaf = new SimpleNode(descendant.getOid(), (byte[])simpleNode.getValue(), simpleNode.getAssertionType());
                                break;
                            }
                            newLeaf = new SimpleNode(descendant.getOid(), simpleNode.getValue().toString(), simpleNode.getAssertionType());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown assertion type: " + leaf.getAssertionType());
                        }
                    }
                    bnode.getChildren().add(newLeaf);
                }
            }
        }
        return nextInterceptor.search(base, env, filter, searchCtls);
    }

    public boolean hasEntry(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        name = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        return nextInterceptor.hasEntry(name);
    }

    public boolean isSuffix(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        name = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        return nextInterceptor.isSuffix(name);
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, LdapDN base) throws NamingException {
        base = LdapDN.normalize((LdapDN)base, (Map)this.attributeRegistry.getNormalizerMapping());
        return nextInterceptor.list(base);
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        name = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        return nextInterceptor.lookup(name);
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name, String[] attrIds) throws NamingException {
        name = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        return nextInterceptor.lookup(name, attrIds);
    }

    public LdapDN getMatchedName(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        name = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        return nextInterceptor.getMatchedName(name);
    }

    public LdapDN getSuffix(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        name = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        return nextInterceptor.getSuffix(name);
    }

    public boolean compare(NextInterceptor next, LdapDN name, String oid, Object value) throws NamingException {
        name = LdapDN.normalize((LdapDN)name, (Map)this.attributeRegistry.getNormalizerMapping());
        return next.compare(name, oid, value);
    }

    public void bind(NextInterceptor next, LdapDN bindDn, byte[] credentials, List mechanisms, String saslAuthId) throws NamingException {
        bindDn = LdapDN.normalize((LdapDN)bindDn, (Map)this.attributeRegistry.getNormalizerMapping());
        next.bind(bindDn, credentials, mechanisms, saslAuthId);
    }

    public void addContextPartition(NextInterceptor next, PartitionConfiguration cfg) throws NamingException {
        next.addContextPartition(cfg);
    }

    public void removeContextPartition(NextInterceptor next, LdapDN suffix) throws NamingException {
        suffix = LdapDN.normalize((LdapDN)suffix, (Map)this.attributeRegistry.getNormalizerMapping());
        next.removeContextPartition(suffix);
    }
}

