/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.util.ArrayList;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;

public abstract class AbstractPartition
implements Partition {
    private DirectoryServiceConfiguration factoryCfg;
    private PartitionConfiguration cfg;
    private boolean initialized;
    private LdapDN suffixDn;

    protected AbstractPartition() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(DirectoryServiceConfiguration factoryCfg, PartitionConfiguration cfg) throws NamingException {
        if (this.initialized) {
            return;
        }
        this.factoryCfg = factoryCfg;
        this.cfg = cfg;
        try {
            this.doInit();
            this.initialized = true;
        }
        finally {
            if (!this.initialized) {
                this.destroy();
            }
        }
    }

    protected void doInit() throws NamingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (this.cfg == null) {
            return;
        }
        try {
            this.doDestroy();
        }
        finally {
            this.initialized = false;
            this.factoryCfg = null;
            this.cfg = null;
        }
    }

    protected void doDestroy() {
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final DirectoryServiceConfiguration getFactoryConfiguration() {
        return this.factoryCfg;
    }

    public final PartitionConfiguration getConfiguration() {
        return this.cfg;
    }

    public final LdapDN getSuffix() throws NamingException {
        if (this.suffixDn == null) {
            this.suffixDn = new LdapDN(this.cfg.getSuffix());
            this.suffixDn.normalize(this.factoryCfg.getGlobalRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        }
        return this.suffixDn;
    }

    public final boolean isSuffix(LdapDN name) throws NamingException {
        return this.getSuffix().equals((Object)name);
    }

    public void sync() throws NamingException {
    }

    public boolean hasEntry(LdapDN name) throws NamingException {
        try {
            return this.lookup(name) != null;
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }

    public Attributes lookup(LdapDN name) throws NamingException {
        return this.lookup(name, null);
    }

    public void modify(LdapDN name, int modOp, Attributes mods) throws NamingException {
        ArrayList<ModificationItemImpl> items = new ArrayList<ModificationItemImpl>(mods.size());
        NamingEnumeration<? extends Attribute> e = mods.getAll();
        while (e.hasMore()) {
            items.add(new ModificationItemImpl(modOp, e.next()));
        }
        ModificationItemImpl[] itemsArray = new ModificationItemImpl[items.size()];
        itemsArray = items.toArray(itemsArray);
        this.modify(name, itemsArray);
    }

    public void move(LdapDN oldName, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
        LdapDN newName = (LdapDN)newParentName.clone();
        newName.add(newRn);
        this.move(oldName, newParentName);
        this.modifyRn(newName, newRn, deleteOldRn);
    }

    public void move(LdapDN oldName, LdapDN newParentName) throws NamingException {
        throw new OperationNotSupportedException("Moving an entry to other parent entry is not supported.");
    }
}

