/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import javax.naming.NamingException;
import org.apache.directory.server.core.configuration.PartitionConfiguration;

public class BTreePartitionConfiguration
extends PartitionConfiguration {
    private boolean synchOnWrite = false;
    private boolean optimizerEnabled = true;

    protected void setOptimizerEnabled(boolean optimizerEnabled) {
        this.optimizerEnabled = optimizerEnabled;
    }

    public boolean isOptimizerEnabled() {
        return this.optimizerEnabled;
    }

    protected void setSynchOnWrite(boolean synchOnWrite) {
        this.synchOnWrite = synchOnWrite;
    }

    public boolean isSynchOnWrite() {
        return this.synchOnWrite;
    }

    public static BTreePartitionConfiguration convert(PartitionConfiguration config) throws NamingException {
        if (config instanceof BTreePartitionConfiguration) {
            return (BTreePartitionConfiguration)config;
        }
        BTreePartitionConfiguration newConfig = new BTreePartitionConfiguration();
        newConfig.setCacheSize(config.getCacheSize());
        newConfig.setContextEntry(config.getContextEntry());
        newConfig.setContextPartition(config.getContextPartition());
        newConfig.setIndexedAttributes(config.getIndexedAttributes());
        newConfig.setName(config.getName());
        newConfig.setSuffix(config.getSuffix());
        return newConfig;
    }
}

