/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.Evaluator;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.AttributeUtils;

public class SubstringEvaluator
implements Evaluator {
    private BTreePartition db;
    private OidRegistry oidRegistry;
    private AttributeTypeRegistry attributeTypeRegistry;

    public SubstringEvaluator(BTreePartition db, OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry) {
        this.db = db;
        this.oidRegistry = oidRegistry;
        this.attributeTypeRegistry = attributeTypeRegistry;
    }

    public boolean evaluate(ExprNode node, IndexRecord record) throws NamingException {
        Attribute attr;
        Pattern regex = null;
        SubstringNode snode = (SubstringNode)node;
        String oid = this.oidRegistry.getOid(snode.getAttribute());
        AttributeType type = this.attributeTypeRegistry.lookup(oid);
        MatchingRule rule = type.getSubstr();
        if (rule == null) {
            rule = type.getEquality();
        }
        Normalizer normalizer = rule.getNormalizer();
        if (this.db.hasUserIndexOn(snode.getAttribute())) {
            Index idx = this.db.getUserIndex(snode.getAttribute());
            IndexEnumeration list = idx.listReverseIndices(record.getEntryId());
            try {
                regex = snode.getRegex(normalizer);
            }
            catch (PatternSyntaxException pse) {
                NamingException ne = new NamingException("SubstringNode '" + node + "' had " + "incorrect syntax");
                ne.setRootCause(pse);
                throw ne;
            }
            while (list.hasMore()) {
                IndexRecord rec = (IndexRecord)list.next();
                if (!regex.matcher((String)rec.getIndexKey()).matches()) continue;
                list.close();
                return true;
            }
            return false;
        }
        if (null == record.getAttributes()) {
            Attributes attrs = this.db.lookup(record.getEntryId());
            record.setAttributes(attrs);
        }
        if (null == (attr = AttributeUtils.getAttribute((Attributes)record.getAttributes(), (AttributeType)type))) {
            return false;
        }
        try {
            regex = snode.getRegex(normalizer);
        }
        catch (PatternSyntaxException pse) {
            NamingException ne = new NamingException("SubstringNode '" + node + "' had " + "incorrect syntax");
            ne.setRootCause(pse);
            throw ne;
        }
        NamingEnumeration<?> list = attr.getAll();
        while (list.hasMore()) {
            String value = (String)normalizer.normalize(list.next());
            if (!regex.matcher(value).matches()) continue;
            list.close();
            return true;
        }
        return false;
    }
}

