/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.swing.tree.TreeNode;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.SearchEngine;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.LdapDN;

public class EntryNode
implements TreeNode {
    private final BTreePartition partition;
    private final EntryNode parent;
    private final Attributes entry;
    private final ArrayList children;
    private final BigInteger id;

    public EntryNode(BigInteger id, EntryNode parent, BTreePartition partition, Attributes entry, HashMap map) {
        this(id, parent, partition, entry, map, null, null);
    }

    public EntryNode(BigInteger id, EntryNode parent, BTreePartition db, Attributes entry, HashMap map, ExprNode exprNode, SearchEngine engine) {
        this.partition = db;
        this.id = id;
        this.entry = entry;
        this.children = new ArrayList();
        this.parent = parent == null ? this : parent;
        try {
            ArrayList<IndexRecord> records = new ArrayList<IndexRecord>();
            NamingEnumeration childList = db.list(id);
            while (childList.hasMore()) {
                IndexRecord old = (IndexRecord)childList.next();
                IndexRecord newRec = new IndexRecord();
                newRec.copy(old);
                records.add(newRec);
            }
            childList.close();
            Iterator list = records.iterator();
            while (list.hasNext()) {
                EntryNode child;
                Attributes newEntry;
                IndexRecord rec = (IndexRecord)list.next();
                if (engine != null && exprNode != null) {
                    if (db.getChildCount(rec.getEntryId()) == 0) {
                        if (!engine.evaluate(exprNode, rec.getEntryId())) continue;
                        newEntry = db.lookup(rec.getEntryId());
                        child = new EntryNode(rec.getEntryId(), this, db, newEntry, map, exprNode, engine);
                        this.children.add(child);
                        continue;
                    }
                    newEntry = db.lookup(rec.getEntryId());
                    child = new EntryNode(rec.getEntryId(), this, db, newEntry, map, exprNode, engine);
                    this.children.add(child);
                    continue;
                }
                newEntry = db.lookup(rec.getEntryId());
                child = new EntryNode(rec.getEntryId(), this, db, newEntry, map);
                this.children.add(child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        map.put(id, this);
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode child) {
        return this.children.indexOf(child);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.children.size() <= 0;
    }

    public String getEntryDn() throws NamingException {
        return this.partition.getEntryDn(this.id);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            LdapDN dn = new LdapDN(this.partition.getEntryDn(this.id));
            buf.append("(").append(this.id).append(") ");
            buf.append(dn.getRdn());
        }
        catch (NamingException e) {
            e.printStackTrace();
            buf.append("ERROR: " + e.getMessage());
        }
        if (this.children.size() > 0) {
            buf.append(" [").append(this.children.size()).append("]");
        }
        return buf.toString();
    }

    public Attributes getLdapEntry() {
        return this.entry;
    }

    public BigInteger getEntryId() {
        return this.id;
    }
}

