/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.prefs;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.configuration.MutableStartupConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.core.jndi.CoreContextFactory;
import org.apache.directory.server.core.prefs.ServerSystemPreferenceException;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.util.PreferencesDictionary;

public class ServerSystemPreferences
extends AbstractPreferences {
    private static final ModificationItemImpl[] EMPTY_MODS = new ModificationItemImpl[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    private LdapContext ctx;
    private ArrayList changes = new ArrayList(3);
    private HashMap keyToChange = new HashMap(3);

    public ServerSystemPreferences() {
        super(null, "");
        this.newNode = false;
        MutableStartupConfiguration cfg = new MutableStartupConfiguration();
        cfg.setAllowAnonymousAccess(true);
        Hashtable<String, String> env = new Hashtable<String, String>(cfg.toJndiEnvironment());
        env.put("java.naming.factory.initial", CoreContextFactory.class.getName());
        env.put("java.naming.provider.url", "prefNodeName=sysPrefRoot,ou=system");
        try {
            this.ctx = new InitialLdapContext(env, null);
        }
        catch (Exception e) {
            throw new ServerSystemPreferenceException("Failed to open.", e);
        }
    }

    public synchronized void close() {
        if (this.parent() != null) {
            throw new ServerSystemPreferenceException("Cannot close child preferences.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>(new ShutdownConfiguration().toJndiEnvironment());
        env.put("java.naming.factory.initial", CoreContextFactory.class.getName());
        env.put("java.naming.provider.url", "prefNodeName=sysPrefRoot,ou=system");
        try {
            this.ctx = new InitialLdapContext(env, null);
        }
        catch (Exception e) {
            throw new ServerSystemPreferenceException("Failed to close.", e);
        }
    }

    public ServerSystemPreferences(ServerSystemPreferences parent, String name) {
        super(parent, name);
        LdapContext parentCtx = parent.getLdapContext();
        try {
            this.ctx = (LdapContext)parentCtx.lookup("prefNodeName=" + name);
            this.newNode = false;
        }
        catch (NamingException e) {
            this.newNode = true;
        }
        if (this.newNode) {
            try {
                this.setUpNode(name);
            }
            catch (Exception e) {
                throw new ServerSystemPreferenceException("Failed to set up node.", e);
            }
        }
    }

    public Dictionary wrapAsDictionary() {
        return new PreferencesDictionary((Preferences)this);
    }

    LdapContext getLdapContext() {
        return this.ctx;
    }

    private void setUpNode(String name) throws NamingException {
        LockableAttributesImpl attrs = new LockableAttributesImpl();
        LockableAttributeImpl attr = new LockableAttributeImpl("objectClass");
        attr.add("top");
        attr.add("prefNode");
        attr.add("extensibleObject");
        attrs.put((Attribute)attr);
        attr = new LockableAttributeImpl("prefNodeName");
        attr.add(name);
        attrs.put((Attribute)attr);
        LdapContext parent = ((ServerSystemPreferences)this.parent()).getLdapContext();
        parent.bind("prefNodeName=" + name, null, (Attributes)attrs);
        this.ctx = (LdapContext)parent.lookup("prefNodeName=" + name);
        this.newNode = false;
    }

    protected void flushSpi() throws BackingStoreException {
        if (this.ctx == null) {
            throw new BackingStoreException("Ldap context not available for " + super.absolutePath());
        }
        if (this.changes.isEmpty()) {
            return;
        }
        try {
            this.ctx.modifyAttributes("", (ModificationItem[])this.changes.toArray(EMPTY_MODS));
        }
        catch (NamingException e) {
            throw new BackingStoreException(e);
        }
        this.changes.clear();
        this.keyToChange.clear();
    }

    protected void removeNodeSpi() throws BackingStoreException {
        try {
            this.ctx.destroySubcontext("");
        }
        catch (NamingException e) {
            throw new BackingStoreException(e);
        }
        this.ctx = null;
        this.changes.clear();
        this.keyToChange.clear();
    }

    protected void syncSpi() throws BackingStoreException {
        if (this.ctx == null) {
            throw new BackingStoreException("Ldap context not available for " + super.absolutePath());
        }
        if (this.changes.isEmpty()) {
            return;
        }
        try {
            this.ctx.modifyAttributes("", (ModificationItem[])this.changes.toArray(EMPTY_MODS));
        }
        catch (NamingException e) {
            throw new BackingStoreException(e);
        }
        this.changes.clear();
        this.keyToChange.clear();
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        ArrayList<String> children = new ArrayList<String>();
        NamingEnumeration<NameClassPair> list = null;
        try {
            list = this.ctx.list("");
            while (list.hasMore()) {
                NameClassPair ncp = list.next();
                children.add(ncp.getName());
            }
        }
        catch (NamingException e) {
            throw new BackingStoreException(e);
        }
        return children.toArray(EMPTY_STRINGS);
    }

    protected String[] keysSpi() throws BackingStoreException {
        Attributes attrs = null;
        ArrayList<String> keys = new ArrayList<String>();
        try {
            attrs = this.ctx.getAttributes("");
            NamingEnumeration<String> ids = attrs.getIDs();
            while (ids.hasMore()) {
                String id = ids.next();
                if (id.equals("objectClass") || id.equals("prefNodeName")) continue;
                keys.add(id);
            }
        }
        catch (NamingException e) {
            throw new BackingStoreException(e);
        }
        return keys.toArray(EMPTY_STRINGS);
    }

    protected void removeSpi(String key) {
        LockableAttributeImpl attr = new LockableAttributeImpl(key);
        ModificationItemImpl mi = new ModificationItemImpl(3, (Attribute)attr);
        this.addDelta(mi);
    }

    private void addDelta(ModificationItemImpl mi) {
        String key = mi.getAttribute().getID();
        List<Object> deltas = null;
        this.changes.add(mi);
        deltas = this.keyToChange.containsKey(key) ? (List)this.keyToChange.get(key) : new ArrayList<ModificationItemImpl>();
        deltas.add(mi);
        this.keyToChange.put(key, deltas);
    }

    protected String getSpi(String key) {
        String value = null;
        try {
            Attribute attr = this.ctx.getAttributes("").get(key);
            if (this.keyToChange.containsKey(key)) {
                List mods = (List)this.keyToChange.get(key);
                for (int ii = 0; ii < mods.size(); ++ii) {
                    ModificationItemImpl mi = (ModificationItemImpl)mods.get(ii);
                    attr = mi.getModificationOp() == 3 ? null : mi.getAttribute();
                }
            }
            if (attr == null) {
                return null;
            }
            value = (String)attr.get();
        }
        catch (Exception e) {
            throw new ServerSystemPreferenceException("Failed to get SPI.", e);
        }
        return value;
    }

    protected void putSpi(String key, String value) {
        LockableAttributeImpl attr = new LockableAttributeImpl(key);
        attr.add(value);
        ModificationItemImpl mi = new ModificationItemImpl(2, (Attribute)attr);
        this.addDelta(mi);
    }

    protected AbstractPreferences childSpi(String name) {
        return new ServerSystemPreferences(this, name);
    }
}

