/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import javax.naming.NamingException;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class ConcreteNameComponentNormalizer
implements NameComponentNormalizer {
    private final AttributeTypeRegistry attributeRegistry;
    private final OidRegistry oidRegistry;

    public ConcreteNameComponentNormalizer(AttributeTypeRegistry registry, OidRegistry oidRegistry) {
        this.attributeRegistry = registry;
        this.oidRegistry = oidRegistry;
    }

    public Object normalizeByName(String name, String value) throws NamingException {
        return this.lookup(name).normalize((Object)value);
    }

    public Object normalizeByName(String name, byte[] value) throws NamingException {
        return this.lookup(name).normalize((Object)value);
    }

    public Object normalizeByOid(String oid, String value) throws NamingException {
        return this.lookup(oid).normalize((Object)value);
    }

    public Object normalizeByOid(String oid, byte[] value) throws NamingException {
        return this.lookup(oid).normalize((Object)value);
    }

    private Normalizer lookup(String id) throws NamingException {
        AttributeType type = this.attributeRegistry.lookup(id);
        MatchingRule mrule = type.getEquality();
        if (mrule == null) {
            return NoOpNormalizer.INSTANCE;
        }
        return type.getEquality().getNormalizer();
    }

    public boolean isDefined(String id) {
        return this.attributeRegistry.hasAttributeType(id);
    }

    public String normalizeName(String attributeName) throws NamingException {
        return this.oidRegistry.getOid(attributeName);
    }
}

