/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class DnNormalizer
implements Normalizer {
    private final AttributeTypeRegistry attrRegistry;

    public DnNormalizer(AttributeTypeRegistry attrRegistry) {
        this.attrRegistry = attrRegistry;
    }

    public Object normalize(Object value) throws NamingException {
        LdapDN dn = null;
        if (value instanceof LdapDN) {
            dn = (LdapDN)((LdapDN)value).clone();
        } else if (value instanceof Name) {
            dn = new LdapDN((Name)value);
        } else if (value instanceof String) {
            dn = new LdapDN((String)value);
        } else {
            throw new NamingException("The DN is not an instance of String, Name or LdapDN");
        }
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return dn.getNormName();
    }
}

