/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.MatchingRuleRegistry;
import org.apache.directory.server.core.schema.MatchingRuleRegistryMonitor;
import org.apache.directory.server.core.schema.MatchingRuleRegistryMonitorAdapter;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapMatchingRuleRegistry;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.util.JoinIterator;

public class GlobalMatchingRuleRegistry
implements MatchingRuleRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private MatchingRuleRegistryMonitor monitor;
    private BootstrapMatchingRuleRegistry bootstrap;

    public GlobalMatchingRuleRegistry(BootstrapMatchingRuleRegistry bootstrap, OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.monitor = new MatchingRuleRegistryMonitorAdapter();
        this.bootstrap = bootstrap;
        if (this.bootstrap == null) {
            throw new NullPointerException("the bootstrap registry cannot be null");
        }
    }

    public void setMonitor(MatchingRuleRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, MatchingRule dITContentRule) throws NamingException {
        if (this.byOid.containsKey(dITContentRule.getOid()) || this.bootstrap.hasMatchingRule(dITContentRule.getOid())) {
            NamingException e = new NamingException("dITContentRule w/ OID " + dITContentRule.getOid() + " has already been registered!");
            this.monitor.registerFailed(dITContentRule, e);
            throw e;
        }
        this.oidRegistry.register(dITContentRule.getName(), dITContentRule.getOid());
        this.byOid.put(dITContentRule.getOid(), dITContentRule);
        this.oidToSchema.put(dITContentRule.getOid(), schema);
        this.monitor.registered(dITContentRule);
    }

    public MatchingRule lookup(String id) throws NamingException {
        if (this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            MatchingRule dITContentRule = (MatchingRule)this.byOid.get(id);
            this.monitor.lookedUp(dITContentRule);
            return dITContentRule;
        }
        if (this.bootstrap.hasMatchingRule(id)) {
            MatchingRule dITContentRule = this.bootstrap.lookup(id);
            this.monitor.lookedUp(dITContentRule);
            return dITContentRule;
        }
        NamingException e = new NamingException("dITContentRule w/ OID " + id + " not registered!");
        this.monitor.lookupFailed(id, e);
        throw e;
    }

    public boolean hasMatchingRule(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id)) || this.bootstrap.hasMatchingRule(id);
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        if (this.bootstrap.hasMatchingRule(id)) {
            return this.bootstrap.getSchemaName(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return new JoinIterator(new Iterator[]{this.byOid.values().iterator(), this.bootstrap.list()});
    }
}

