/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.Comparator;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.ComparatorRegistry;
import org.apache.directory.server.core.schema.MatchingRuleRegistry;
import org.apache.directory.server.core.schema.NormalizerRegistry;
import org.apache.directory.server.core.schema.ObjectClassRegistry;
import org.apache.directory.server.core.schema.SyntaxCheckerRegistry;
import org.apache.directory.server.core.schema.SyntaxRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapProducer;
import org.apache.directory.server.core.schema.bootstrap.BootstrapRegistries;
import org.apache.directory.server.core.schema.bootstrap.ProducerTypeEnum;
import org.apache.directory.shared.ldap.schema.AbstractAttributeType;
import org.apache.directory.shared.ldap.schema.AbstractMatchingRule;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.AbstractSyntax;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.UsageEnum;

public abstract class AbstractBootstrapProducer
implements BootstrapProducer {
    protected static final String[] EMPTY = new String[0];
    private final ProducerTypeEnum type;

    protected AbstractBootstrapProducer(ProducerTypeEnum type) {
        this.type = type;
    }

    public ProducerTypeEnum getType() {
        return this.type;
    }

    protected static BootstrapSyntax newSyntax(String oid, BootstrapRegistries registries) {
        return new BootstrapSyntax(oid, registries.getSyntaxCheckerRegistry());
    }

    protected static BootstrapAttributeType newAttributeType(String oid, BootstrapRegistries registries) {
        return new BootstrapAttributeType(oid, registries);
    }

    protected static BootstrapObjectClass newObjectClass(String oid, BootstrapRegistries registries) {
        return new BootstrapObjectClass(oid, registries);
    }

    public static class BootstrapObjectClass
    extends AbstractSchemaObject
    implements ObjectClass {
        private final ObjectClassRegistry objectClassRegistry;
        private final AttributeTypeRegistry attributeTypeRegistry;
        private String[] superClassIds = EMPTY;
        private ObjectClass[] superClasses;
        private ObjectClassTypeEnum type = ObjectClassTypeEnum.STRUCTURAL;
        private String[] mayListIds = EMPTY;
        private AttributeType[] mayList;
        private String[] mustListIds = EMPTY;
        private AttributeType[] mustList;

        protected BootstrapObjectClass(String oid, BootstrapRegistries registries) {
            super(oid);
            this.objectClassRegistry = registries.getObjectClassRegistry();
            this.attributeTypeRegistry = registries.getAttributeTypeRegistry();
        }

        public ObjectClass[] getSuperClasses() throws NamingException {
            if (this.superClasses == null) {
                this.superClasses = new ObjectClass[this.superClassIds.length];
            }
            for (int ii = 0; ii < this.superClassIds.length; ++ii) {
                this.superClasses[ii] = this.objectClassRegistry.lookup(this.superClassIds[ii]);
            }
            return this.superClasses;
        }

        public void setSuperClassIds(String[] superClassIds) {
            this.superClassIds = superClassIds;
        }

        public ObjectClassTypeEnum getType() {
            return this.type;
        }

        public void setType(ObjectClassTypeEnum type) {
            this.type = type;
        }

        public AttributeType[] getMustList() throws NamingException {
            if (this.mustList == null) {
                this.mustList = new AttributeType[this.mustListIds.length];
            }
            for (int ii = 0; ii < this.mustListIds.length; ++ii) {
                this.mustList[ii] = this.attributeTypeRegistry.lookup(this.mustListIds[ii]);
            }
            return this.mustList;
        }

        public void setMustListIds(String[] mustListIds) {
            this.mustListIds = mustListIds;
        }

        public AttributeType[] getMayList() throws NamingException {
            if (this.mayList == null) {
                this.mayList = new AttributeType[this.mayListIds.length];
            }
            for (int ii = 0; ii < this.mayListIds.length; ++ii) {
                this.mayList[ii] = this.attributeTypeRegistry.lookup(this.mayListIds[ii]);
            }
            return this.mayList;
        }

        public void setMayListIds(String[] mayListIds) {
            this.mayListIds = mayListIds;
        }

        public void setObsolete(boolean obsolete) {
            super.setObsolete(obsolete);
        }

        public void setNames(String[] names) {
            super.setNames(names);
        }

        public void setDescription(String description) {
            super.setDescription(description);
        }
    }

    public static class BootstrapAttributeType
    extends AbstractAttributeType {
        private static final long serialVersionUID = 4050205236738471984L;
        private final SyntaxRegistry syntaxRegistry;
        private final MatchingRuleRegistry matchingRuleRegistry;
        private final AttributeTypeRegistry attributeTypeRegistry;
        private String superiorId;
        private String equalityId;
        private String substrId;
        private String orderingId;
        private String syntaxId;

        protected BootstrapAttributeType(String oid, BootstrapRegistries registries) {
            super(oid);
            this.syntaxRegistry = registries.getSyntaxRegistry();
            this.matchingRuleRegistry = registries.getMatchingRuleRegistry();
            this.attributeTypeRegistry = registries.getAttributeTypeRegistry();
        }

        public void setSuperiorId(String superiorId) {
            this.superiorId = superiorId;
        }

        public AttributeType getSuperior() throws NamingException {
            if (this.superiorId == null) {
                return null;
            }
            return this.attributeTypeRegistry.lookup(this.superiorId);
        }

        public void setNames(String[] names) {
            super.setNames(names);
        }

        public MatchingRule getEquality() throws NamingException {
            if (this.equalityId != null) {
                return this.matchingRuleRegistry.lookup(this.equalityId);
            }
            if (this.superiorId != null) {
                return this.getSuperior().getEquality();
            }
            return null;
        }

        public void setEqualityId(String equalityId) {
            this.equalityId = equalityId;
        }

        public MatchingRule getSubstr() throws NamingException {
            if (this.substrId != null) {
                return this.matchingRuleRegistry.lookup(this.substrId);
            }
            if (this.superiorId != null) {
                return this.getSuperior().getSubstr();
            }
            return null;
        }

        public void setSubstrId(String substrId) {
            this.substrId = substrId;
        }

        public MatchingRule getOrdering() throws NamingException {
            if (this.orderingId != null) {
                return this.matchingRuleRegistry.lookup(this.orderingId);
            }
            if (this.superiorId != null) {
                return this.getSuperior().getOrdering();
            }
            return null;
        }

        public void setOrderingId(String orderingId) {
            this.orderingId = orderingId;
        }

        public void setSyntaxId(String syntaxId) {
            this.syntaxId = syntaxId;
        }

        public Syntax getSyntax() throws NamingException {
            if (this.syntaxId != null) {
                return this.syntaxRegistry.lookup(this.syntaxId);
            }
            if (this.superiorId != null) {
                return this.getSuperior().getSyntax();
            }
            return null;
        }

        public void setSingleValue(boolean singleValue) {
            super.setSingleValue(singleValue);
        }

        public void setCollective(boolean collective) {
            super.setCollective(collective);
        }

        public void setCanUserModify(boolean canUserModify) {
            super.setCanUserModify(canUserModify);
        }

        public void setObsolete(boolean obsolete) {
            super.setObsolete(obsolete);
        }

        public void setDescription(String description) {
            super.setDescription(description);
        }

        public void setUsage(UsageEnum usage) {
            super.setUsage(usage);
        }

        public void setLength(int length) {
            super.setLength(length);
        }
    }

    public static class BootstrapMatchingRule
    extends AbstractMatchingRule {
        final SyntaxRegistry syntaxRegistry;
        final NormalizerRegistry normalizerRegistry;
        final ComparatorRegistry comparatorRegistry;
        String syntaxOid;

        protected BootstrapMatchingRule(String oid, BootstrapRegistries registries) {
            super(oid);
            this.syntaxRegistry = registries.getSyntaxRegistry();
            this.normalizerRegistry = registries.getNormalizerRegistry();
            this.comparatorRegistry = registries.getComparatorRegistry();
        }

        public void setNames(String[] names) {
            super.setNames(names);
        }

        public void setSyntaxOid(String syntaxOid) {
            this.syntaxOid = syntaxOid;
        }

        public void setDescription(String description) {
            super.setDescription(description);
        }

        public void setObsolete(boolean isObsolete) {
            super.setObsolete(isObsolete);
        }

        public Syntax getSyntax() throws NamingException {
            return this.syntaxRegistry.lookup(this.syntaxOid);
        }

        public Comparator getComparator() throws NamingException {
            return this.comparatorRegistry.lookup(this.getOid());
        }

        public Normalizer getNormalizer() throws NamingException {
            return this.normalizerRegistry.lookup(this.getOid());
        }
    }

    public static class BootstrapSyntax
    extends AbstractSyntax {
        final SyntaxCheckerRegistry registry;

        protected BootstrapSyntax(String oid, SyntaxCheckerRegistry registry) {
            super(oid);
            this.registry = registry;
        }

        public void setDescription(String description) {
            super.setDescription(description);
        }

        public void setHumanReadible(boolean isHumanReadible) {
            super.setHumanReadible(isHumanReadible);
        }

        public void setNames(String[] names) {
            super.setNames(names);
        }

        public SyntaxChecker getSyntaxChecker() throws NamingException {
            return this.registry.lookup(this.getOid());
        }

        public boolean isObsolete() {
            return false;
        }
    }
}

