/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.AttributeTypeRegistryMonitor;
import org.apache.directory.server.core.schema.AttributeTypeRegistryMonitorAdapter;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapAttributeTypeRegistry
implements AttributeTypeRegistry {
    private static final Logger log = LoggerFactory.getLogger((Class)BootstrapAttributeTypeRegistry.class);
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final Map oidToDescendantSet = new HashMap();
    private final OidRegistry oidRegistry;
    private AttributeTypeRegistryMonitor monitor;
    private transient Map mapping;

    public BootstrapAttributeTypeRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.monitor = new AttributeTypeRegistryMonitorAdapter();
    }

    public void setMonitor(AttributeTypeRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, AttributeType attributeType) throws NamingException {
        if (this.byOid.containsKey(attributeType.getOid())) {
            NamingException e = new NamingException("attributeType w/ OID " + attributeType.getOid() + " has already been registered!");
            this.monitor.registerFailed(attributeType, e);
            throw e;
        }
        String[] names = attributeType.getNames();
        for (int ii = 0; ii < names.length; ++ii) {
            this.oidRegistry.register(names[ii], attributeType.getOid());
        }
        this.registerDescendants(attributeType);
        this.oidToSchema.put(attributeType.getOid(), schema);
        this.byOid.put(attributeType.getOid(), attributeType);
        this.monitor.registered(attributeType);
    }

    public void registerDescendants(AttributeType attributeType) throws NamingException {
        this.oidToDescendantSet.put(attributeType.getOid(), new HashSet(5));
        this.onRegisterAddToAncestorDescendants(attributeType, attributeType.getSuperior());
    }

    protected void onRegisterAddToAncestorDescendants(AttributeType newType, AttributeType ancestor) throws NamingException {
        if (ancestor == null || ancestor.getName().equals("top")) {
            return;
        }
        HashSet<AttributeType> descendants = (HashSet<AttributeType>)this.oidToDescendantSet.get(ancestor.getOid());
        if (descendants == null) {
            descendants = new HashSet<AttributeType>(5);
            this.oidToDescendantSet.put(ancestor.getOid(), descendants);
        }
        descendants.add(newType);
        this.onRegisterAddToAncestorDescendants(newType, ancestor.getSuperior());
    }

    public AttributeType lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            NamingException e = new NamingException("attributeType w/ OID " + id + " not registered!");
            this.monitor.lookupFailed(id, e);
            throw e;
        }
        AttributeType attributeType = (AttributeType)this.byOid.get(id);
        this.monitor.lookedUp(attributeType);
        return attributeType;
    }

    public boolean hasAttributeType(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return this.byOid.values().iterator();
    }

    public Map getNormalizerMapping() throws NamingException {
        if (this.mapping == null) {
            this.mapping = new HashMap(this.byOid.size() << 1);
            Iterator ii = this.byOid.values().iterator();
            while (ii.hasNext()) {
                AttributeType type = (AttributeType)ii.next();
                MatchingRule matchingRule = type.getEquality();
                OidNormalizer oidNormalizer = null;
                if (matchingRule == null) {
                    log.warn("Attribute " + type.getName() + " does not have normalizer : using NoopNormalizer");
                    oidNormalizer = new OidNormalizer(type.getOid(), (Normalizer)new NoOpNormalizer());
                } else {
                    oidNormalizer = new OidNormalizer(type.getOid(), matchingRule.getNormalizer());
                }
                this.mapping.put(type.getOid(), oidNormalizer);
                String[] aliases = type.getNames();
                for (int jj = 0; jj < aliases.length; ++jj) {
                    this.mapping.put(aliases[jj], oidNormalizer);
                    this.mapping.put(aliases[jj].toLowerCase(), oidNormalizer);
                }
            }
        }
        return Collections.unmodifiableMap(this.mapping);
    }

    public Iterator descendants(String ancestorId) throws NamingException {
        String oid = this.oidRegistry.getOid(ancestorId);
        Set descendants = (Set)this.oidToDescendantSet.get(oid);
        if (descendants == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return descendants.iterator();
    }

    public boolean hasDescendants(String ancestorId) throws NamingException {
        String oid = this.oidRegistry.getOid(ancestorId);
        Set descendants = (Set)this.oidToDescendantSet.get(oid);
        if (descendants == null) {
            return false;
        }
        return !descendants.isEmpty();
    }
}

