/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.DITStructureRuleRegistry;
import org.apache.directory.server.core.schema.DITStructureRuleRegistryMonitor;
import org.apache.directory.server.core.schema.DITStructureRuleRegistryMonitorAdapter;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.schema.DITStructureRule;

public class BootstrapDitStructureRuleRegistry
implements DITStructureRuleRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private DITStructureRuleRegistryMonitor monitor = new DITStructureRuleRegistryMonitorAdapter();

    public BootstrapDitStructureRuleRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
    }

    public void setMonitor(DITStructureRuleRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, DITStructureRule dITStructureRule) throws NamingException {
        if (this.byOid.containsKey(dITStructureRule.getOid())) {
            NamingException e = new NamingException("dITStructureRule w/ OID " + dITStructureRule.getOid() + " has already been registered!");
            this.monitor.registerFailed(dITStructureRule, e);
            throw e;
        }
        this.oidToSchema.put(dITStructureRule.getOid(), schema);
        this.oidRegistry.register(dITStructureRule.getName(), dITStructureRule.getOid());
        this.byOid.put(dITStructureRule.getOid(), dITStructureRule);
        this.monitor.registered(dITStructureRule);
    }

    public DITStructureRule lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            NamingException e = new NamingException("dITStructureRule w/ OID " + id + " not registered!");
            this.monitor.lookupFailed(id, e);
            throw e;
        }
        DITStructureRule dITStructureRule = (DITStructureRule)this.byOid.get(id);
        this.monitor.lookedUp(dITStructureRule);
        return dITStructureRule;
    }

    public boolean hasDITStructureRule(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return this.byOid.values().iterator();
    }
}

