/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.MatchingRuleRegistry;
import org.apache.directory.server.core.schema.MatchingRuleRegistryMonitor;
import org.apache.directory.server.core.schema.MatchingRuleRegistryMonitorAdapter;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.schema.MatchingRule;

public class BootstrapMatchingRuleRegistry
implements MatchingRuleRegistry {
    private final Map byOid;
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private MatchingRuleRegistryMonitor monitor = null;

    public BootstrapMatchingRuleRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.byOid = new HashMap();
        this.monitor = new MatchingRuleRegistryMonitorAdapter();
    }

    public MatchingRule lookup(String id) throws NamingException {
        if (this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            MatchingRule MatchingRule2 = (MatchingRule)this.byOid.get(id);
            this.monitor.lookedUp(MatchingRule2);
            return MatchingRule2;
        }
        NamingException fault = new NamingException("Unknown MatchingRule OID " + id);
        this.monitor.lookupFailed(id, fault);
        throw fault;
    }

    public void register(String schema, MatchingRule matchingRule) throws NamingException {
        if (this.byOid.containsKey(matchingRule.getOid())) {
            NamingException e = new NamingException("matchingRule w/ OID " + matchingRule.getOid() + " has already been registered!");
            this.monitor.registerFailed(matchingRule, e);
            throw e;
        }
        this.oidToSchema.put(matchingRule.getOid(), schema);
        String[] names = matchingRule.getNames();
        for (int ii = 0; ii < names.length; ++ii) {
            this.oidRegistry.register(names[ii], matchingRule.getOid());
        }
        this.byOid.put(matchingRule.getOid(), matchingRule);
        this.monitor.registered(matchingRule);
    }

    public boolean hasMatchingRule(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    MatchingRuleRegistryMonitor getMonitor() {
        return this.monitor;
    }

    void setMonitor(MatchingRuleRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public Iterator list() {
        return this.byOid.values().iterator();
    }
}

