/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.SyntaxCheckerRegistry;
import org.apache.directory.server.core.schema.SyntaxCheckerRegistryMonitor;
import org.apache.directory.server.core.schema.SyntaxCheckerRegistryMonitorAdapter;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;

public class BootstrapSyntaxCheckerRegistry
implements SyntaxCheckerRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private SyntaxCheckerRegistryMonitor monitor = new SyntaxCheckerRegistryMonitorAdapter();

    public void setMonitor(SyntaxCheckerRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, String oid, SyntaxChecker syntaxChecker) throws NamingException {
        if (this.byOid.containsKey(oid)) {
            NamingException e = new NamingException("SyntaxChecker with OID " + oid + " already registered!");
            this.monitor.registerFailed(oid, syntaxChecker, e);
            throw e;
        }
        this.byOid.put(oid, syntaxChecker);
        this.oidToSchema.put(oid, schema);
        this.monitor.registered(oid, syntaxChecker);
    }

    public SyntaxChecker lookup(String oid) throws NamingException {
        if (!this.byOid.containsKey(oid)) {
            NamingException e = new NamingException("SyntaxChecker for OID " + oid + " not found!");
            this.monitor.lookupFailed(oid, e);
            throw e;
        }
        SyntaxChecker syntaxChecker = (SyntaxChecker)this.byOid.get(oid);
        this.monitor.lookedUp(oid, syntaxChecker);
        return null;
    }

    public boolean hasSyntaxChecker(String oid) {
        return this.byOid.containsKey(oid);
    }

    public String getSchemaName(String oid) throws NamingException {
        if (Character.isDigit(oid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        if (this.oidToSchema.containsKey(oid)) {
            return (String)this.oidToSchema.get(oid);
        }
        throw new NamingException("OID " + oid + " not found in oid to " + "schema name map!");
    }
}

