/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.directory.server.core.subtree.RefinementLeafEvaluator;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;

public class RefinementEvaluator {
    private RefinementLeafEvaluator leafEvaluator;

    public RefinementEvaluator(RefinementLeafEvaluator leafEvaluator) {
        this.leafEvaluator = leafEvaluator;
    }

    public boolean evaluate(ExprNode node, Attribute objectClasses) throws NamingException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        if (objectClasses == null) {
            throw new IllegalArgumentException("objectClasses cannot be null");
        }
        if (!objectClasses.getID().equalsIgnoreCase("objectClass")) {
            throw new IllegalArgumentException("Attribute objectClasses should be of id 'objectClass'");
        }
        if (node.isLeaf()) {
            return this.leafEvaluator.evaluate((SimpleNode)node, objectClasses);
        }
        BranchNode bnode = (BranchNode)node;
        switch (bnode.getOperator()) {
            case 9: {
                Iterator children = bnode.getChildren().iterator();
                while (children.hasNext()) {
                    ExprNode child = (ExprNode)children.next();
                    if (!this.evaluate(child, objectClasses)) continue;
                    return true;
                }
                return false;
            }
            case 10: {
                Iterator children = bnode.getChildren().iterator();
                while (children.hasNext()) {
                    ExprNode child = (ExprNode)children.next();
                    if (this.evaluate(child, objectClasses)) continue;
                    return false;
                }
                return true;
            }
            case 11: {
                if (null != bnode.getChild()) {
                    return !this.evaluate(bnode.getChild(), objectClasses);
                }
                throw new IllegalArgumentException("Negation has no child: " + node);
            }
        }
        throw new IllegalArgumentException("Unrecognized branch node operator: " + bnode.getOperator());
    }
}

