/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import java.util.Iterator;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.subtree.RefinementEvaluator;
import org.apache.directory.server.core.subtree.RefinementLeafEvaluator;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.util.NamespaceTools;

public class SubtreeEvaluator {
    private final RefinementEvaluator evaluator;

    public SubtreeEvaluator(OidRegistry registry) {
        RefinementLeafEvaluator leafEvaluator = new RefinementLeafEvaluator(registry);
        this.evaluator = new RefinementEvaluator(leafEvaluator);
    }

    public boolean evaluate(SubtreeSpecification subtree, Name apDn, Name entryDn, Attribute objectClasses) throws NamingException {
        Object baseRelativeRdn;
        if (!NamespaceTools.isDescendant((Name)apDn, (Name)entryDn)) {
            return false;
        }
        Object apRelativeRdn = apDn.equals(entryDn) ? new LdapDN() : NamespaceTools.getRelativeName((Name)apDn, (Name)entryDn);
        if (subtree.getBase() != null && subtree.getBase().size() == 0) {
            baseRelativeRdn = apRelativeRdn;
        } else if (apRelativeRdn.equals(subtree.getBase())) {
            baseRelativeRdn = new LdapDN();
        } else {
            if (!NamespaceTools.isDescendant((Name)subtree.getBase(), (Name)apRelativeRdn)) {
                return false;
            }
            baseRelativeRdn = NamespaceTools.getRelativeName((Name)subtree.getBase(), (Name)apRelativeRdn);
        }
        if (subtree.getMaxBaseDistance() != -1 && subtree.getMaxBaseDistance() < baseRelativeRdn.size()) {
            return false;
        }
        if (subtree.getMinBaseDistance() > 0 && baseRelativeRdn.size() < subtree.getMinBaseDistance()) {
            return false;
        }
        Iterator list = subtree.getChopBeforeExclusions().iterator();
        while (list.hasNext()) {
            Name chopBefore = (Name)list.next();
            if (!NamespaceTools.isDescendant((Name)chopBefore, (Name)baseRelativeRdn)) continue;
            return false;
        }
        list = subtree.getChopAfterExclusions().iterator();
        while (list.hasNext()) {
            Name chopAfter = (Name)list.next();
            if (!NamespaceTools.isDescendant((Name)chopAfter, (Name)baseRelativeRdn) || chopAfter.equals(baseRelativeRdn)) continue;
            return false;
        }
        if (subtree.getRefinement() != null) {
            return this.evaluator.evaluate(subtree.getRefinement(), objectClasses);
        }
        return true;
    }
}

