/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.runtime.control.cmd;

import org.kohsuke.args4j.Option;
import org.openthinclient.common.ApplicationVersionUtil;
import org.openthinclient.runtime.control.cmd.AbstractCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowVersionCommand
extends AbstractCommand<Options> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowVersionCommand.class);

    public ShowVersionCommand() {
        super("version");
    }

    @Override
    public Options createOptionsObject() {
        return new Options();
    }

    @Override
    public void execute(Options options) {
        ApplicationVersionUtil.PomProperties pom = ApplicationVersionUtil.readPomProperties();
        String version = pom.getVersion();
        LOGGER.debug("Application version is {}", (Object)version);
        System.out.println("Application version is " + version == null ? "unknown" : version);
        if (options.detail) {
            String buildDate = pom.getBuildDate();
            System.out.println("Creation date " + buildDate == null ? "unknown" : buildDate);
        }
    }

    public class Options {
        @Option(name="-v", usage="Print detail information of version")
        public boolean detail;
    }
}

