/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.progress;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openthinclient.progress.ProgressReceiver;

public class DownloadProgressTrackingInputStream
extends FilterInputStream {
    private final long contentLength;
    private final ProgressReceiver receiver;
    private long alreadyRead = 0L;

    public DownloadProgressTrackingInputStream(InputStream in, long contentLength, ProgressReceiver receiver) {
        super(in);
        this.contentLength = contentLength;
        this.receiver = receiver;
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res >= 0) {
            this.updateProgress(1);
        }
        return res;
    }

    private void updateProgress(int count) {
        this.alreadyRead += (long)count;
        double percentage = (double)this.alreadyRead / (double)this.contentLength;
        this.receiver.progress(percentage);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read > 0) {
            this.updateProgress(read);
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.receiver.completed();
    }
}

