/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.standalone.config;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.service.common.home.ManagerHome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ManagerHomeCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(ManagerHomeCleaner.class);
    private static long MAX_HISTORY_DAYS = 20L;
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private PackageManager packageManager;
    private Path managerHomePath;
    private static final Path REPORTS_PATH = Paths.get("nfs", "home", "reports");
    private static final Path ARCHIVES_PATH = Paths.get("nfs", "root", "var", "cache", "archives");

    public void clean() {
        LOG.info("Start cleaning manager home.");
        this.managerHomePath = this.managerHome.getLocation().toPath();
        long notBefore = OffsetDateTime.now().minusDays(MAX_HISTORY_DAYS).toEpochSecond() * 1000L;
        this.cleanReports(notBefore);
        this.cleanLogs(notBefore);
        this.cleanPackagesCache(notBefore);
    }

    private void cleanReports(long notBefore) {
        File reportsDir = this.managerHomePath.resolve(REPORTS_PATH).toFile();
        if (reportsDir.isDirectory()) {
            for (File subdir : reportsDir.listFiles(File::isDirectory)) {
                for (File file2 : subdir.listFiles(file -> file.lastModified() < notBefore)) {
                    this.deleteFile(file2);
                }
            }
        }
    }

    private void cleanLogs(long notBefore) {
        Path logPath = this.managerHomePath.resolve("logs");
        this.deleteOldZips(logPath.toFile(), notBefore);
        this.deleteOldZips(logPath.resolve("syslog").toFile(), notBefore);
    }

    private void deleteOldZips(File dir, long notBefore) {
        if (!dir.isDirectory()) {
            LOG.warn("{} is not a directory", (Object)dir);
            return;
        }
        for (File file2 : dir.listFiles(file -> file.getName().endsWith(".zip") && file.lastModified() < notBefore)) {
            this.deleteFile(file2);
        }
    }

    private void cleanPackagesCache(long notBefore) {
        if (this.packageManager.isRunning()) {
            LOG.info("Package manager running. Skipping cleanup of package cache.");
            return;
        }
        File archivesDir = this.managerHomePath.resolve(ARCHIVES_PATH).toFile();
        HashMap packages = new HashMap();
        for (File subdir : archivesDir.listFiles(File::isDirectory)) {
            for (File file : subdir.listFiles()) {
                String pkgName = file.getName().split("_", 2)[0];
                if (!packages.containsKey(pkgName)) {
                    packages.put(pkgName, new ArrayList());
                }
                ((List)packages.get(pkgName)).add(file);
            }
        }
        for (List pkgFiles : packages.values()) {
            if (pkgFiles.size() <= 1) continue;
            pkgFiles.sort(Comparator.comparing(File::lastModified).reversed());
            pkgFiles.remove(0);
            for (File file : pkgFiles) {
                if (file.lastModified() >= notBefore) continue;
                this.deleteFile(file);
            }
        }
    }

    private void deleteFile(File file) {
        LOG.info("Removing {}", (Object)file);
        try {
            file.delete();
        }
        catch (SecurityException ex) {
            LOG.error(String.format("Failed to delete file %s", file.getName()), (Throwable)ex);
        }
    }
}

