/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.standalone.config;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.Version;
import org.openthinclient.pkgmgr.op.PackageManagerOperationReport;
import org.openthinclient.service.common.ServerIDFactory;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.home.ManagerHomeMetadata;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.pkgmngr.event.PackageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"serviceManager", "liquibase"})
public class Migrations {
    private static Logger LOG = LoggerFactory.getLogger(Migrations.class);
    private static Version v2020 = Version.parse((String)"2020");
    private static Version v2021 = Version.parse((String)"2021");
    private static Version v2021b2 = Version.parse((String)"2021.2~beta2~");
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private PackageManager pkgManager;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    @Autowired
    private LocationService locationService;
    private static String[] obsoletePackageNames = new String[]{"openthinclient-manager", "openthinclient-server-tftp", "openthinclient-server-ldap", "openthinclient-server-dhcp", "openthinclient-server-nfs", "tcos-scripts"};
    private static String[] obsoleteWithTcosLibs2020PackageNames = new String[]{"tcos-devices", "desktop"};
    private static String[] extensions = new String[]{"sfs", "md5", "changelog"};

    public void setServerId() {
        ManagerHomeMetadata meta = this.managerHome.getMetadata();
        if (Strings.isNullOrEmpty((String)meta.getServerID())) {
            meta.setServerID(ServerIDFactory.create());
            meta.save();
        }
        LOG.info("Server ID: {}", (Object)meta.getServerID());
    }

    @PostConstruct
    public void init() {
        this.setServerId();
        this.runLDAPMigration();
        this.removeObsoletePackageFiles(obsoletePackageNames);
        this.removeObsoleteSyslogFiles();
    }

    @EventListener
    public void onPackageEvent(PackageEvent ev) {
        if (this.isUpdate(ev.getReports(), "tcos-libs", v2020)) {
            this.updateLocationTimezone();
            this.removeObsoletePackageFiles(obsoleteWithTcosLibs2020PackageNames);
        }
        if (this.isUpdate(ev.getReports(), "tcos-libs", v2021)) {
            this.fixLocationLanguageKey();
        }
        if (this.isUpdate(ev.getReports(), "tcos-libs", v2021b2)) {
            this.updateHardwaretypeBootOptions();
        }
    }

    @EventListener
    public void runLDAPMigration(DashboardEvent.LDAPImportEvent ev) {
        this.runLDAPMigration();
    }

    public void runLDAPMigration() {
        if (this.isInstalled("tcos-libs", v2020)) {
            this.updateLocationTimezone();
            this.removeObsoletePackageFiles(obsoleteWithTcosLibs2020PackageNames);
        }
        if (this.isInstalled("tcos-libs", v2021)) {
            this.fixLocationLanguageKey();
        }
        if (this.isInstalled("tcos-libs", v2021b2)) {
            this.updateHardwaretypeBootOptions();
        }
    }

    private void removeObsoleteSyslogFiles() {
        File logDir = this.managerHome.getLocation().toPath().resolve("logs").toFile();
        if (logDir.isDirectory()) {
            for (File file : logDir.listFiles((d, name) -> name.startsWith("syslog."))) {
                try {
                    file.delete();
                }
                catch (SecurityException ex) {
                    LOG.error(String.format("Failed to delete obsolete log file %s", file.getName()), (Throwable)ex);
                }
            }
        }
    }

    private void removeObsoletePackageFiles(String[] packageNames) {
        Path root = this.pkgManager.getConfiguration().getInstallDir().toPath();
        Path pkgPath = root.resolve("sfs/package");
        for (String pkgName : packageNames) {
            for (String ext : extensions) {
                try {
                    Path path = pkgPath.resolve(pkgName + "." + ext);
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    LOG.info("Deleting obsolete {}", (Object)path);
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void updateLocationTimezone() {
        for (Location location : this.locationService.findAll()) {
            String tz = location.getValueLocal("Time.localtime");
            if (tz == null || !tz.startsWith("posix/")) continue;
            LOG.info("Updating timezone for {}", (Object)location.getName());
            location.setValue("Time.localtime", tz.substring(6));
            this.locationService.save((DirectoryObject)location);
        }
    }

    private void fixLocationLanguageKey() {
        for (Location location : this.locationService.findAll()) {
            String lang = location.getValueLocal("Lang.lang");
            if (lang == null || !lang.equals("de_BE.UFT-8")) continue;
            LOG.info("Updating language de_BE.UFT-8 for {}", (Object)location.getName());
            location.setValue("Lang.lang", "de_BE.UTF-8");
            this.locationService.save((DirectoryObject)location);
        }
    }

    private void updateHardwaretypeBootOptions() {
        for (HardwareType hwtype : this.hardwareTypeService.findAll()) {
            if (hwtype.containsValue("BootOptions.BootMode") || !hwtype.containsValue("BootOptions.BootfileName") && !hwtype.containsValue("BootOptions.BootLoaderTemplate")) continue;
            LOG.info("Updating boot mode for {}", (Object)hwtype.getName());
            String template = hwtype.getValueLocal("BootOptions.BootLoaderTemplate");
            if (template != null) {
                boolean isHTTPBoot = "template-http.txt".equals(template);
                hwtype.setValue("BootOptions.BootMode", isHTTPBoot ? "fast" : "safe");
            }
            hwtype.removeValue("BootOptions.BootfileName");
            hwtype.removeValue("BootOptions.BootLoaderTemplate");
            this.hardwareTypeService.save((DirectoryObject)hwtype);
        }
    }

    private boolean is(Package pkg, String name, Version version) {
        return name.equals(pkg.getName()) && version.compareTo(pkg.getVersion()) <= 0;
    }

    private boolean isInstalled(String name, Version version) {
        return this.pkgManager.getInstalledPackages().stream().anyMatch(pkg -> this.is((Package)pkg, name, version));
    }

    private boolean isUpdate(List<PackageManagerOperationReport.PackageReport> reports, String name, Version version) {
        return reports.stream().anyMatch(report -> this.is(report.getPackage(), name, version) && (report.getType().equals((Object)PackageManagerOperationReport.PackageReportType.UPGRADE) || report.getType().equals((Object)PackageManagerOperationReport.PackageReportType.INSTALL)));
    }
}

