/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.standalone.config.service;

import org.openthinclient.service.nfs.NFSService;
import org.openthinclient.web.pkgmngr.event.PackageEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class NFSServiceConfiguration {
    private NFSService service;

    @Bean
    public NFSService nfsService() {
        this.service = new NFSService();
        return this.service;
    }

    @Scheduled(cron="0 0 11 * * 1-5")
    public void restartNFSService() {
        if (this.service != null && this.service.isRunning()) {
            this.service.restartService();
        }
    }

    @EventListener
    public void onPackageEvent(PackageEvent ev) {
        this.restartNFSService();
    }
}

