/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.components;

import com.vaadin.server.ErrorMessage;
import com.vaadin.server.UserError;
import com.vaadin.ui.Upload;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class UploadFileHandler
extends Upload
implements Upload.Receiver {
    protected final FileHandler fileHandler;

    public UploadFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
        this.setReceiver(this);
    }

    public OutputStream receiveUpload(String filename, String mimeType) {
        try {
            PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            this.writeResponce(in, filename, mimeType);
            return out;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void writeResponce(final PipedInputStream in, final String filename, final String mimeType) {
        new Thread(){

            @Override
            public void run() {
                try {
                    UploadFileHandler.this.fileHandler.handleFile(in, filename, mimeType);
                    in.close();
                }
                catch (Exception e) {
                    UploadFileHandler.this.getUI().access(() -> {
                        UploadFileHandler.this.setComponentError((ErrorMessage)new UserError("Handling file failed"));
                        throw new RuntimeException(e);
                    });
                }
            }
        }.start();
    }

    @FunctionalInterface
    public static interface FileHandler {
        public void handleFile(InputStream var1, String var2, String var3);
    }
}

