/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.fields;

import com.vaadin.event.FieldEvents;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.viritin.fields.AbstractNumberField;

public class DoubleField
extends AbstractNumberField<DoubleField, Double> {
    private static final long serialVersionUID = 377246000306551089L;
    private String step = "any";
    private Double definedStep;

    public DoubleField() {
        this.setSizeUndefined();
    }

    public DoubleField(String caption) {
        this.setSizeUndefined();
        this.setCaption(caption);
    }

    @Override
    protected void userInputToValue(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str = str.replaceAll(",", ".");
            this.value = Double.parseDouble(str);
        } else {
            this.value = null;
        }
    }

    public DoubleField withBlurListener(FieldEvents.BlurListener listener) {
        return (DoubleField)super.withBlurListener(listener);
    }

    public DoubleField withFocusListener(FieldEvents.FocusListener listener) {
        return (DoubleField)super.withFocusListener(listener);
    }

    public DoubleField withStep(Double step) {
        this.definedStep = step;
        return this;
    }

    public Double getValue() {
        return (Double)this.value;
    }

    @Override
    protected void configureHtmlElement() {
        if (this.definedStep != null) {
            this.step = String.valueOf(this.definedStep);
        } else if (this.getValue() != null) {
            String s = String.valueOf(this.getValue()).replaceAll("\\d", "0").replaceAll("(\\d{1})$", "1");
            if ("any".equals(this.step) || s.length() > this.step.length()) {
                this.step = s;
            }
        }
        this.s.setProperty("step", this.step);
        this.s.setProperty("type", this.getHtmlFieldType());
        this.s.setJavaScriptEventHandler("keypress", "function(e) {if(e.metaKey ||\u00a0e.ctrlKey) return true; var c = viritin.getChar(e); if( (c === '.' || c === ',') && this.value != '' && this.value.indexOf('.') == -1 && this.value.indexOf(',') == -1) return true; return c==null || /^[-\\d\\n\\t\\r]+$/.test(c);}");
    }
}

